/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xmlrpc.AuthDemo;
import org.apache.xmlrpc.Base64;
import org.apache.xmlrpc.Echo;
import org.apache.xmlrpc.ServerInputStream;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcServer;

public class WebServer
implements Runnable {
    protected XmlRpcServer xmlrpc;
    protected ServerSocket serverSocket;
    protected int port;
    protected Thread listener;
    protected boolean paranoid;
    protected Vector accept;
    protected Vector deny;
    protected Stack threadpool;
    protected ThreadGroup runners;
    protected static final byte[] ctype = "Content-Type: text/xml\r\n".getBytes();
    protected static final byte[] clength = "Content-Length: ".getBytes();
    protected static final byte[] newline = "\r\n".getBytes();
    protected static final byte[] doubleNewline = "\r\n\r\n".getBytes();
    protected static final byte[] conkeep = "Connection: Keep-Alive\r\n".getBytes();
    protected static final byte[] conclose = "Connection: close\r\n".getBytes();
    protected static final byte[] ok = " 200 OK\r\n".getBytes();
    protected static final byte[] server = "Server: Apache XML-RPC 1.0\r\n".getBytes();
    private static final String HTTP_11 = "HTTP/1.1";
    private static final String STAR = "*";
    static /* synthetic */ Class class$org$apache$xmlrpc$WebServer;
    static /* synthetic */ Class class$java$lang$Math;

    public static void main(String[] stringArray) {
        System.err.println("Usage: java " + (class$org$apache$xmlrpc$WebServer == null ? (class$org$apache$xmlrpc$WebServer = WebServer.class$("org.apache.xmlrpc.WebServer")) : class$org$apache$xmlrpc$WebServer).getName() + " <port>");
        int n = 8080;
        if (stringArray.length > 0) {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error parsing port number: " + stringArray[0]);
            }
        }
        XmlRpc.setKeepAlive(true);
        try {
            WebServer webServer = new WebServer(n);
            webServer.addHandler("string", "Welcome to XML-RPC!");
            webServer.addHandler("math", class$java$lang$Math == null ? (class$java$lang$Math = WebServer.class$("java.lang.Math")) : class$java$lang$Math);
            webServer.addHandler("auth", new AuthDemo());
            webServer.addHandler("$default", new Echo());
            webServer.addHandler("mttf", new XmlRpcClient("http://www.mailtothefuture.com:80/RPC2"));
            System.err.println("started web server on port " + n);
        }
        catch (IOException iOException) {
            System.err.println("Error creating web server: " + iOException);
        }
    }

    public WebServer(int n) throws IOException {
        this(n, null);
    }

    public WebServer(int n, InetAddress inetAddress) throws IOException {
        this.port = n;
        this.xmlrpc = new XmlRpcServer();
        this.accept = new Vector();
        this.deny = new Vector();
        this.threadpool = new Stack();
        this.runners = new ThreadGroup("XML-RPC Runner");
        try {
            this.setupServerSocket(n, 50, inetAddress);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        this.start();
    }

    protected ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws Exception {
        return new ServerSocket(n, n2, inetAddress);
    }

    public void setupServerSocket(int n, int n2, InetAddress inetAddress) throws Exception {
        this.serverSocket = this.createServerSocket(n, n2, inetAddress);
        this.serverSocket.setSoTimeout(4096);
    }

    public void start() {
        this.listener = new Thread((Runnable)this, "XML-RPC Weblistener");
        this.listener.start();
    }

    public void addHandler(String string, Object object) {
        this.xmlrpc.addHandler(string, object);
    }

    public void removeHandler(String string) {
        this.xmlrpc.removeHandler(string);
    }

    public void setParanoid(boolean bl) {
        this.paranoid = bl;
    }

    public void acceptClient(String string) throws IllegalArgumentException {
        try {
            AddressMatcher addressMatcher = new AddressMatcher(string);
            this.accept.addElement(addressMatcher);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("\"" + string + "\" does not represent a valid IP address");
        }
    }

    public void denyClient(String string) throws IllegalArgumentException {
        try {
            AddressMatcher addressMatcher = new AddressMatcher(string);
            this.deny.addElement(addressMatcher);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("\"" + string + "\" does not represent a valid IP address");
        }
    }

    protected boolean checkSocket(Socket socket) {
        int n = this.deny.size();
        byte[] byArray = socket.getInetAddress().getAddress();
        int n2 = 0;
        while (n2 < n) {
            AddressMatcher addressMatcher = (AddressMatcher)this.deny.elementAt(n2);
            if (addressMatcher.matches(byArray)) {
                return false;
            }
            ++n2;
        }
        n = this.accept.size();
        int n3 = 0;
        while (n3 < n) {
            AddressMatcher addressMatcher = (AddressMatcher)this.accept.elementAt(n3);
            if (addressMatcher.matches(byArray)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                while (this.listener != null) {
                    try {
                        var1_1 = this.serverSocket.accept();
                        if (!this.paranoid || this.checkSocket(var1_1)) {
                            var2_4 = this.getRunner();
                            var2_4.handle(var1_1);
                            continue;
                        }
                        var1_1.close();
                    }
                    catch (InterruptedIOException var1_2) {
                    }
                    catch (Exception var2_5) {
                        System.err.println("Exception in XML-RPC listener loop (" + var2_5 + ").");
                    }
                    catch (Error var3_6) {
                        System.err.println("Error in XML-RPC listener loop (" + var3_6 + ").");
                    }
                }
            }
            catch (Exception var1_3) {
                System.err.println("Error accepting XML-RPC connections (" + var1_3 + ").");
                var5_8 = null;
                System.err.println("Closing XML-RPC server socket.");
                try {
                    this.serverSocket.close();
                    this.serverSocket = null;
                    return;
                }
                catch (IOException var6_11) {
                    return;
                }
            }
            var5_7 = null;
            System.err.println("Closing XML-RPC server socket.");
        }
        catch (Throwable var4_13) {
            var5_9 = null;
            System.err.println("Closing XML-RPC server socket.");
            ** try [egrp 3[TRYBLOCK] [5 : 183->198)] { 
lbl40:
            // 1 sources

            this.serverSocket.close();
            this.serverSocket = null;
            throw var4_13;
lbl43:
            // 1 sources

            catch (IOException var6_12) {
                // empty catch block
            }
            throw var4_13;
        }
        try {}
        catch (IOException var6_10) {}
        this.serverSocket.close();
        this.serverSocket = null;
        return;
    }

    public void shutdown() {
        Object object;
        if (this.listener != null) {
            object = this.listener;
            this.listener = null;
            ((Thread)object).interrupt();
        }
        if (this.runners != null) {
            object = this.runners;
            this.runners = null;
            try {
                ((ThreadGroup)object).interrupt();
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
            try {
                if (!((ThreadGroup)object).isDestroyed()) {
                    ((ThreadGroup)object).destroy();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Runner getRunner() {
        try {
            return (Runner)this.threadpool.pop();
        }
        catch (EmptyStackException emptyStackException) {
            if (this.runners.activeCount() > 255) {
                throw new RuntimeException("System overload");
            }
            return new Runner();
        }
    }

    void releaseRunner(Runner runner) {
        this.threadpool.push(runner);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AddressMatcher {
        int[] pattern = new int[4];

        public AddressMatcher(String string) throws Exception {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.countTokens() != 4) {
                throw new Exception("\"" + string + "\" does not represent a valid IP address");
            }
            int n = 0;
            while (n < 4) {
                String string2 = stringTokenizer.nextToken();
                this.pattern[n] = WebServer.STAR.equals(string2) ? 256 : (int)((byte)Integer.parseInt(string2));
                ++n;
            }
        }

        public boolean matches(byte[] byArray) {
            int n = 0;
            while (n < 4) {
                if (this.pattern[n] <= 255 && this.pattern[n] != byArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    class Connection
    implements Runnable {
        private Socket socket;
        private BufferedInputStream input;
        private BufferedOutputStream output;
        private String user;
        private String password;
        byte[] buffer;

        public Connection(Socket socket) throws IOException {
            socket.setSoTimeout(30000);
            this.socket = socket;
            this.input = new BufferedInputStream(socket.getInputStream());
            this.output = new BufferedOutputStream(socket.getOutputStream());
        }

        /*
         * Loose catch block
         */
        public void run() {
            block22: {
                boolean bl = false;
                do {
                    Object object;
                    this.password = null;
                    this.user = null;
                    String string = this.readLine();
                    if (string != null && string.length() == 0) {
                        string = this.readLine();
                    }
                    if (XmlRpc.debug) {
                        System.err.println(string);
                    }
                    int n = -1;
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    boolean bl2 = bl = XmlRpc.getKeepAlive() && WebServer.HTTP_11.equals(string4);
                    do {
                        if ((string = this.readLine()) == null) continue;
                        if (XmlRpc.debug) {
                            System.err.println(string);
                        }
                        if (((String)(object = string.toLowerCase())).startsWith("content-length:")) {
                            n = Integer.parseInt(string.substring(15).trim());
                        }
                        if (((String)object).startsWith("connection:")) {
                            boolean bl3 = bl = XmlRpc.getKeepAlive() && ((String)object).indexOf("keep-alive") > -1;
                        }
                        if (!((String)object).startsWith("authorization: basic ")) continue;
                        this.parseAuth(string);
                    } while (string != null && string.length() != 0);
                    if ("POST".equalsIgnoreCase(string2)) {
                        object = new ServerInputStream(this.input, n);
                        byte[] byArray = WebServer.this.xmlrpc.execute((InputStream)object, this.user, this.password);
                        this.output.write(string4.getBytes());
                        this.output.write(ok);
                        this.output.write(server);
                        if (bl) {
                            this.output.write(conkeep);
                        } else {
                            this.output.write(conclose);
                        }
                        this.output.write(ctype);
                        this.output.write(clength);
                        this.output.write(Integer.toString(byArray.length).getBytes());
                        this.output.write(doubleNewline);
                        this.output.write(byArray);
                        this.output.flush();
                        continue;
                    }
                    this.output.write(string4.getBytes());
                    this.output.write(" 400 Bad Request\r\n".getBytes());
                    this.output.write(server);
                    this.output.write("\r\n".getBytes());
                    this.output.write(("Method " + string2 + " not implemented (try POST)").getBytes());
                    this.output.flush();
                    bl = false;
                } while (bl);
                Object var11_11 = null;
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                    break block22;
                }
                catch (IOException iOException) {}
                break block22;
                {
                    catch (Exception exception) {
                        if (XmlRpc.debug) {
                            System.err.println(exception);
                            exception.printStackTrace();
                        }
                        Object var11_12 = null;
                        try {
                            if (this.socket != null) {
                                this.socket.close();
                            }
                            break block22;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    try {
                        if (this.socket != null) {
                            this.socket.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        private String readLine() throws IOException {
            int n;
            if (this.buffer == null) {
                this.buffer = new byte[2048];
            }
            int n2 = 0;
            while ((n = this.input.read()) >= 0 && n != 10) {
                if (n != 13) {
                    this.buffer[n2++] = (byte)n;
                }
                if (n2 < this.buffer.length) continue;
                throw new IOException("HTTP Header too long");
            }
            return new String(this.buffer, 0, n2);
        }

        private void parseAuth(String string) {
            try {
                byte[] byArray = Base64.decode(string.substring(21).getBytes());
                String string2 = new String(byArray);
                int n = string2.indexOf(58);
                this.user = string2.substring(0, n);
                this.password = string2.substring(n + 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class Runner
    implements Runnable {
        Thread thread;
        Connection con;
        int count;

        Runner() {
        }

        public synchronized void handle(Socket socket) throws IOException {
            this.con = new Connection(socket);
            this.count = 0;
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread(WebServer.this.runners, this);
                this.thread.start();
            } else {
                this.notify();
            }
        }

        public void run() {
            while (this.con != null && Thread.currentThread() == this.thread) {
                this.con.run();
                ++this.count;
                this.con = null;
                if (this.count > 200 || WebServer.this.threadpool.size() > 20) {
                    return;
                }
                Runner runner = this;
                synchronized (runner) {
                    WebServer.this.releaseRunner(this);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }
}

