/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xmlrpc.AuthenticatedXmlRpcHandler;
import org.apache.xmlrpc.Invoker;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;

public class XmlRpcServer {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private Hashtable handlers = new Hashtable();
    private Stack pool = new Stack();
    private int workers = 0;

    public void addHandler(String string, Object object) {
        if (object instanceof XmlRpcHandler || object instanceof AuthenticatedXmlRpcHandler) {
            this.handlers.put(string, object);
        } else if (object != null) {
            this.handlers.put(string, new Invoker(object));
        }
    }

    public void removeHandler(String string) {
        this.handlers.remove(string);
    }

    public byte[] execute(InputStream inputStream) {
        return this.execute(inputStream, null, null);
    }

    public byte[] execute(InputStream inputStream, String string, String string2) {
        Worker worker = this.getWorker();
        byte[] byArray = worker.execute(inputStream, string, string2);
        this.pool.push(worker);
        return byArray;
    }

    private final Worker getWorker() {
        try {
            return (Worker)this.pool.pop();
        }
        catch (EmptyStackException emptyStackException) {
            int n = XmlRpc.getMaxThreads();
            if (this.workers < n) {
                ++this.workers;
                if ((double)this.workers >= (double)n * 0.95) {
                    System.err.println("95% of XML-RPC server threads in use");
                }
                return new Worker();
            }
            throw new RuntimeException("System overload");
        }
    }

    static /* synthetic */ Hashtable access$000(XmlRpcServer xmlRpcServer) {
        return xmlRpcServer.handlers;
    }

    static /* synthetic */ byte[] access$100() {
        return EMPTY_BYTE_ARRAY;
    }

    class Worker
    extends XmlRpc {
        private Vector inParams = new Vector();
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private XmlRpc.XmlWriter writer;

        protected Worker() {
        }

        public byte[] execute(InputStream inputStream, String string, String string2) {
            try {
                byte[] byArray = this.executeInternal(inputStream, string, string2);
                Object var6_5 = null;
                this.buffer.reset();
                this.inParams.removeAllElements();
                return byArray;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.buffer.reset();
                this.inParams.removeAllElements();
                throw throwable;
            }
        }

        /*
         * Unable to fully structure code
         */
        private byte[] executeInternal(InputStream var1_1, String var2_2, String var3_3) {
            block27: {
                var5_4 = 0L;
                if (XmlRpc.debug) {
                    var5_4 = System.currentTimeMillis();
                }
                try {
                    this.parse(var1_1);
                    if (XmlRpc.debug) {
                        System.err.println("method name: " + this.methodName);
                        System.err.println("inparams: " + this.inParams);
                    }
                    if (this.errorLevel > 0) {
                        throw new Exception(this.errorMsg);
                    }
                    var7_5 = null;
                    var8_7 = null;
                    var9_10 = this.methodName.lastIndexOf(46);
                    if (var9_10 > -1) {
                        var8_7 = this.methodName.substring(0, var9_10);
                        var7_5 = XmlRpcServer.access$000(XmlRpcServer.this).get(var8_7);
                        if (var7_5 != null) {
                            this.methodName = this.methodName.substring(var9_10 + 1);
                        }
                    }
                    if (var7_5 == null) {
                        var7_5 = XmlRpcServer.access$000(XmlRpcServer.this).get("$default");
                    }
                    if (var7_5 == null) {
                        if (var9_10 > -1) {
                            throw new Exception("RPC handler object \"" + var8_7 + "\" not found and no default handler registered.");
                        }
                        throw new Exception("RPC handler object not found for \"" + this.methodName + "\": no default handler registered.");
                    }
                    var10_13 = var7_5 instanceof AuthenticatedXmlRpcHandler != false ? ((AuthenticatedXmlRpcHandler)var7_5).execute(this.methodName, this.inParams, var2_2, var3_3) : ((XmlRpcHandler)var7_5).execute(this.methodName, this.inParams);
                    if (XmlRpc.debug) {
                        System.err.println("outparam = " + var10_13);
                    }
                    this.writer = new XmlRpc.XmlWriter(this, this.buffer);
                    this.writeResponse(var10_13, this.writer);
                    this.writer.flush();
                    var4_15 = this.buffer.toByteArray();
                    var12_16 = null;
                    ** if (this.writer == null) goto lbl-1000
                }
                catch (Throwable var11_22) {
                    var12_18 = null;
                    if (this.writer != null) {
                        try {
                            this.writer.close();
                        }
                        catch (IOException var13_21) {
                            System.err.println("Exception closing output stream: " + var13_21);
                        }
                    }
                    throw var11_22;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        this.writer.close();
                    }
                    catch (IOException var13_19) {
                        System.err.println("Exception closing output stream: " + var13_19);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block27;
                    catch (Exception var7_6) {
                        if (XmlRpc.debug) {
                            var7_6.printStackTrace();
                        }
                        this.buffer.reset();
                        this.writer = null;
                        try {
                            this.writer = new XmlRpc.XmlWriter(this, this.buffer);
                        }
                        catch (UnsupportedEncodingException var8_8) {
                            System.err.println("XmlRpcServer attempted to use unsupported encoding: " + var8_8);
                        }
                        catch (IOException var9_11) {
                            System.err.println("XmlRpcServer experienced I/O error writing error response: " + var9_11);
                        }
                        var8_9 = var7_6.toString();
                        var9_12 = var7_6 instanceof XmlRpcException != false ? ((XmlRpcException)var7_6).code : 0;
                        try {
                            this.writeError(var9_12, var8_9, this.writer);
                            this.writer.flush();
                        }
                        catch (Exception var10_14) {
                            System.err.println("Unable to send error response to client: " + var10_14);
                        }
                        var4_15 = this.writer != null ? this.buffer.toByteArray() : XmlRpcServer.access$100();
                        var12_17 = null;
                        if (this.writer != null) {
                            try {
                                this.writer.close();
                            }
                            catch (IOException var13_20) {
                                System.err.println("Exception closing output stream: " + var13_20);
                            }
                        }
                    }
                }
            }
            if (XmlRpc.debug) {
                System.err.println("Spent " + (System.currentTimeMillis() - var5_4) + " millis in request");
            }
            return var4_15;
        }

        void objectParsed(Object object) {
            this.inParams.addElement(object);
        }

        void writeResponse(Object object, XmlRpc.XmlWriter xmlWriter) throws XmlRpcException, IOException {
            xmlWriter.startElement("methodResponse");
            xmlWriter.startElement("params");
            xmlWriter.startElement("param");
            xmlWriter.writeObject(object);
            xmlWriter.endElement("param");
            xmlWriter.endElement("params");
            xmlWriter.endElement("methodResponse");
        }

        void writeError(int n, String string, XmlRpc.XmlWriter xmlWriter) throws XmlRpcException, IOException {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("faultCode", new Integer(n));
            hashtable.put("faultString", string);
            xmlWriter.startElement("methodResponse");
            xmlWriter.startElement("fault");
            xmlWriter.writeObject(hashtable);
            xmlWriter.endElement("fault");
            xmlWriter.endElement("methodResponse");
        }
    }
}

