/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import org.apache.xalan.processor.ProcessorTemplateElem;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.templates.ElemElement;
import org.apache.xalan.templates.ElemExsltFuncResult;
import org.apache.xalan.templates.ElemExsltFunction;
import org.apache.xalan.templates.ElemFallback;
import org.apache.xalan.templates.ElemLiteralResult;
import org.apache.xalan.templates.ElemParam;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemValueOf;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xml.utils.SAXSourceLocator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProcessorExsltFunction
extends ProcessorTemplateElem {
    public void startElement(StylesheetHandler handler, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        String msg = "";
        if (!(handler.getElemTemplateElement() instanceof StylesheetRoot)) {
            msg = "func:function element must be top level.";
            handler.error(msg, new SAXException(msg));
        }
        super.startElement(handler, uri, localName, rawName, attributes);
        String val = attributes.getValue("name");
        int indexOfColon = val.indexOf(":");
        if (indexOfColon > 0) {
            String prefix = val.substring(0, indexOfColon);
            String localVal = val.substring(indexOfColon + 1);
            String ns = handler.getNamespaceSupport().getURI(prefix);
        } else {
            msg = "func:function name must have namespace";
            handler.error(msg, new SAXException(msg));
        }
    }

    protected void appendAndPush(StylesheetHandler handler, ElemTemplateElement elem) throws SAXException {
        super.appendAndPush(handler, elem);
        elem.setDOMBackPointer(handler.getOriginatingNode());
        handler.getStylesheet().setTemplate((ElemTemplate)elem);
    }

    public void endElement(StylesheetHandler handler, String uri, String localName, String rawName) throws SAXException {
        ElemTemplateElement function = handler.getElemTemplateElement();
        SAXSourceLocator locator = handler.getLocator();
        this.validate(function, handler);
        super.endElement(handler, uri, localName, rawName);
    }

    public void validate(ElemTemplateElement elem, StylesheetHandler handler) throws SAXException {
        String msg = "";
        while (elem != null) {
            if (elem instanceof ElemExsltFuncResult && elem.getNextSiblingElem() != null && !(elem.getNextSiblingElem() instanceof ElemFallback)) {
                msg = "func:result has an illegal following sibling (only xsl:fallback allowed)";
                handler.error(msg, new SAXException(msg));
            }
            if (elem instanceof ElemValueOf || (elem instanceof ElemLiteralResult || elem instanceof ElemElement) && !this.ancestorIsOk(elem)) {
                msg = "misplaced literal result in a func:function container.";
                handler.error(msg, new SAXException(msg));
            }
            ElemTemplateElement nextElem = elem.getFirstChildElem();
            while (nextElem == null) {
                nextElem = elem.getNextSiblingElem();
                if (nextElem == null) {
                    elem = elem.getParentElem();
                }
                if (elem != null && !(elem instanceof ElemExsltFunction)) continue;
                return;
            }
            elem = nextElem;
        }
    }

    boolean ancestorIsOk(ElemTemplateElement child) {
        while (child.getParentElem() != null && !(child.getParentElem() instanceof ElemExsltFunction)) {
            ElemTemplateElement parent = child.getParentElem();
            if (parent instanceof ElemExsltFuncResult || parent instanceof ElemVariable || parent instanceof ElemParam) {
                return true;
            }
            child = parent;
        }
        return false;
    }
}

