/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Hashtable;

public final class ContextMap
implements Serializable {
    private static final ThreadLocal LOCAL_CONTEXT = new InheritableThreadLocal();
    private final ContextMap m_parent;
    private Hashtable m_map = new Hashtable();
    private transient boolean m_readOnly;

    public static final ContextMap getCurrentContext() {
        return ContextMap.getCurrentContext(true);
    }

    public static final ContextMap getCurrentContext(boolean autocreate) {
        ContextMap context = (ContextMap)LOCAL_CONTEXT.get();
        if (context == null && autocreate) {
            context = new ContextMap();
            LOCAL_CONTEXT.set(context);
        }
        return context;
    }

    public static final void bind(ContextMap context) {
        LOCAL_CONTEXT.set(context);
    }

    public final void makeReadOnly() {
        this.m_readOnly = true;
    }

    public final boolean isReadOnly() {
        return this.m_readOnly;
    }

    public final void clear() {
        this.checkReadable();
        this.m_map.clear();
    }

    public final Object get(String key, Object defaultObject) {
        Object object = this.get(key);
        if (object != null) {
            return object;
        }
        return defaultObject;
    }

    public final Object get(String key) {
        Object result = this.m_map.get(key);
        if (result == null && this.m_parent != null) {
            return this.m_parent.get(key);
        }
        return result;
    }

    public final void set(String key, Object value) {
        this.checkReadable();
        if (value == null) {
            this.m_map.remove(key);
        } else {
            this.m_map.put(key, value);
        }
    }

    public final int getSize() {
        return this.m_map.size();
    }

    private final Object readResolve() throws ObjectStreamException {
        this.makeReadOnly();
        return this;
    }

    private final void checkReadable() {
        if (this.isReadOnly()) {
            throw new IllegalStateException("ContextMap is read only and can not be modified");
        }
    }

    public ContextMap() {
        this(null);
    }

    public ContextMap(ContextMap parent) {
        this.m_parent = parent;
    }
}

