/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import java.io.Serializable;

public final class Priority
implements Serializable {
    public static final Priority DEBUG = new Priority("DEBUG", 5);
    public static final Priority INFO = new Priority("INFO", 10);
    public static final Priority WARN = new Priority("WARN", 15);
    public static final Priority ERROR = new Priority("ERROR", 20);
    public static final Priority FATAL_ERROR = new Priority("FATAL_ERROR", 25);
    public static final Priority NONE = new Priority("NONE", Integer.MAX_VALUE);
    private final String m_name;
    private final int m_priority;

    public static final Priority getPriorityForName(String priority) {
        if (DEBUG.getName().equals(priority)) {
            return DEBUG;
        }
        if (INFO.getName().equals(priority)) {
            return INFO;
        }
        if (WARN.getName().equals(priority)) {
            return WARN;
        }
        if (ERROR.getName().equals(priority)) {
            return ERROR;
        }
        if (FATAL_ERROR.getName().equals(priority)) {
            return FATAL_ERROR;
        }
        if (NONE.getName().equals(priority)) {
            return NONE;
        }
        return DEBUG;
    }

    public final String toString() {
        return "Priority[" + this.getName() + "/" + this.getValue() + "]";
    }

    public final int getValue() {
        return this.m_priority;
    }

    public final String getName() {
        return this.m_name;
    }

    public final boolean isGreater(Priority other) {
        return this.m_priority > other.getValue();
    }

    public final boolean isLower(Priority other) {
        return this.m_priority < other.getValue();
    }

    public final boolean isLowerOrEqual(Priority other) {
        return this.m_priority <= other.getValue();
    }

    private final Object readResolve() {
        return Priority.getPriorityForName(this.m_name);
    }

    private Priority(String name, int priority) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.m_name = name;
        this.m_priority = priority;
    }
}

