/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.format;

import org.apache.log.LogEvent;
import org.apache.log.format.ExceptionUtil;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.PatternFormatter;

public class AvalonFormatter
extends ExtendedPatternFormatter {
    private static final int TYPE_CLASS = 9;
    private static final String TYPE_CLASS_STR = "class";
    private static final String TYPE_CLASS_SHORT_STR = "short";
    public static final int DEFAULT_STACK_DEPTH = 8;
    public static final boolean DEFAULT_PRINT_CASCADING = true;
    private final int m_stackDepth;
    private final boolean m_printCascading;

    protected String getStackTrace(Throwable throwable, String format) {
        if (throwable == null) {
            return "";
        }
        return ExceptionUtil.printStackTrace(throwable, this.m_stackDepth, this.m_printCascading);
    }

    protected int getTypeIdFor(String type) {
        if (type.equalsIgnoreCase(TYPE_CLASS_STR)) {
            return 9;
        }
        return super.getTypeIdFor(type);
    }

    protected String formatPatternRun(LogEvent event, PatternFormatter.PatternRun run) {
        switch (run.m_type) {
            case 9: {
                return this.getClass(run.m_format);
            }
        }
        return super.formatPatternRun(event, run);
    }

    private final String getClass(String format) {
        return "Unknown-class";
    }

    public AvalonFormatter(String pattern) {
        this(pattern, 8, true);
    }

    public AvalonFormatter(String pattern, int stackDepth, boolean printCascading) {
        super(pattern);
        this.m_stackDepth = stackDepth;
        this.m_printCascading = printCascading;
    }
}

