/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.format;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

final class ExceptionUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String GET_CAUSE_NAME = "getCause";
    private static final Class[] GET_CAUSE_PARAMTYPES = new Class[0];
    private static final Class CASCADING_INTERFACE;

    public static final String printStackTrace(Throwable throwable) {
        return ExceptionUtil.printStackTrace(throwable, 0, true);
    }

    public static final String printStackTrace(Throwable throwable, boolean printCascading) {
        return ExceptionUtil.printStackTrace(throwable, 0, printCascading);
    }

    public static final String printStackTrace(Throwable throwable, int depth) {
        int dp = depth;
        String[] lines = ExceptionUtil.captureStackTrace(throwable);
        if (dp == 0 || dp > lines.length) {
            dp = lines.length;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < dp) {
            sb.append(lines[i]);
            sb.append(LINE_SEPARATOR);
            ++i;
        }
        return sb.toString();
    }

    public static final String printStackTrace(Throwable throwable, int depth, boolean printCascading) {
        return ExceptionUtil.printStackTrace(throwable, depth, printCascading, true);
    }

    public static final String printStackTrace(Throwable throwable, int depth, boolean printCascading, boolean useReflection) {
        String result = ExceptionUtil.printStackTrace(throwable, depth);
        if (!printCascading) {
            return result;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(result);
        Throwable cause = ExceptionUtil.getCause(throwable, useReflection);
        while (cause != null) {
            sb.append("rethrown from");
            sb.append(LINE_SEPARATOR);
            sb.append(ExceptionUtil.printStackTrace(cause, depth));
            cause = ExceptionUtil.getCause(cause, useReflection);
        }
        return sb.toString();
    }

    public static final Throwable getCause(Throwable throwable, boolean useReflection) {
        if (useReflection || CASCADING_INTERFACE != null && CASCADING_INTERFACE.isAssignableFrom(throwable.getClass())) {
            try {
                Class<?> clazz = throwable.getClass();
                Method method = clazz.getMethod(GET_CAUSE_NAME, GET_CAUSE_PARAMTYPES);
                return (Throwable)method.invoke((Object)throwable, null);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    public static final String[] captureStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        return ExceptionUtil.splitStringInternal(sw.toString(), LINE_SEPARATOR);
    }

    public static final String[] splitString(String string, String onToken) {
        return ExceptionUtil.splitStringInternal(string, onToken);
    }

    private static final String[] splitStringInternal(String string, String onToken) {
        StringTokenizer tokenizer = new StringTokenizer(string, onToken);
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }

    private ExceptionUtil() {
    }

    static {
        Class<?> klass = null;
        try {
            klass = Class.forName("org.apache.avalon.framework.CascadingThrowable");
        }
        catch (Exception e) {
            klass = null;
        }
        CASCADING_INTERFACE = klass;
    }
}

