/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.format;

import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.format.PatternFormatter;
import org.apache.log.util.StackIntrospector;

public class ExtendedPatternFormatter
extends PatternFormatter {
    private static final int TYPE_METHOD = 9;
    private static final int TYPE_THREAD = 10;
    private static final String TYPE_METHOD_STR = "method";
    private static final String TYPE_THREAD_STR = "thread";
    private int m_callStackOffset = 0;
    private static /* synthetic */ Class class$Lorg$apache$log$Logger;

    protected int getTypeIdFor(String type) {
        if (type.equalsIgnoreCase(TYPE_METHOD_STR)) {
            return 9;
        }
        if (type.equalsIgnoreCase(TYPE_THREAD_STR)) {
            return 10;
        }
        return super.getTypeIdFor(type);
    }

    protected String formatPatternRun(LogEvent event, PatternFormatter.PatternRun run) {
        switch (run.m_type) {
            case 9: {
                return this.getMethod(event, run.m_format);
            }
            case 10: {
                return this.getThread(event, run.m_format);
            }
        }
        return super.formatPatternRun(event, run);
    }

    private final String getMethod(LogEvent event, String format) {
        Object object;
        ContextMap map = event.getContextMap();
        if (map != null && (object = map.get(TYPE_METHOD_STR)) != null) {
            return object.toString();
        }
        Class clazz = StackIntrospector.getCallerClass(class$Lorg$apache$log$Logger != null ? class$Lorg$apache$log$Logger : (class$Lorg$apache$log$Logger = ExtendedPatternFormatter.class$("org.apache.log.Logger")), this.m_callStackOffset - 1);
        if (clazz == null) {
            return "UnknownMethod";
        }
        String result = StackIntrospector.getCallerMethod(clazz);
        if (result == null) {
            return "UnknownMethod";
        }
        return result;
    }

    private final String getThread(LogEvent event, String format) {
        Object object;
        ContextMap map = event.getContextMap();
        if (map != null && (object = map.get(TYPE_THREAD_STR)) != null) {
            return object.toString();
        }
        return Thread.currentThread().getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ExtendedPatternFormatter(String format) {
        this(format, 0);
    }

    public ExtendedPatternFormatter(String format, int callStackOffset) {
        super(format);
        this.m_callStackOffset = callStackOffset;
    }
}

