/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.format;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import org.apache.log.ContextMap;
import org.apache.log.ContextStack;
import org.apache.log.LogEvent;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;

public class PatternFormatter
implements Formatter,
org.apache.log.Formatter {
    private static final int TYPE_TEXT = 1;
    private static final int TYPE_CATEGORY = 2;
    private static final int TYPE_CONTEXT = 3;
    private static final int TYPE_MESSAGE = 4;
    private static final int TYPE_TIME = 5;
    private static final int TYPE_RELATIVE_TIME = 6;
    private static final int TYPE_THROWABLE = 7;
    private static final int TYPE_PRIORITY = 8;
    private static final int TYPE_THREAD = 9;
    protected static final int MAX_TYPE = 8;
    private static final String TYPE_CATEGORY_STR = "category";
    private static final String TYPE_CONTEXT_STR = "context";
    private static final String TYPE_MESSAGE_STR = "message";
    private static final String TYPE_TIME_STR = "time";
    private static final String TYPE_RELATIVE_TIME_STR = "rtime";
    private static final String TYPE_THROWABLE_STR = "throwable";
    private static final String TYPE_PRIORITY_STR = "priority";
    private static final String TYPE_THREAD_STR = "thread";
    private static final String SPACE_16 = "                ";
    private static final String SPACE_8 = "        ";
    private static final String SPACE_4 = "    ";
    private static final String SPACE_2 = "  ";
    private static final String SPACE_1 = " ";
    private static final String EOL = System.getProperty("line.separator", "\n");
    private PatternRun[] m_formatSpecification;
    private SimpleDateFormat m_simpleDateFormat;
    private final Date m_date = new Date();

    private final int addPatternRun(Stack stack, char[] pattern, int index) {
        int total;
        PatternRun run = new PatternRun();
        int start = index++;
        if ('+' == pattern[index]) {
            ++index;
        } else if ('-' == pattern[index]) {
            run.m_rightJustify = true;
            ++index;
        }
        if (Character.isDigit(pattern[index])) {
            total = 0;
            while (Character.isDigit(pattern[index])) {
                total = total * 10 + (pattern[index] - 48);
                ++index;
            }
            run.m_minSize = total;
        }
        if (index < pattern.length && '.' == pattern[index] && Character.isDigit(pattern[++index])) {
            total = 0;
            while (Character.isDigit(pattern[index])) {
                total = total * 10 + (pattern[index] - 48);
                ++index;
            }
            run.m_maxSize = total;
        }
        if (index >= pattern.length || '{' != pattern[index]) {
            throw new IllegalArgumentException("Badly formed pattern at character " + index);
        }
        int typeStart = index;
        while (index < pattern.length && pattern[index] != ':' && pattern[index] != '}') {
            ++index;
        }
        int typeEnd = index - 1;
        String type = new String(pattern, typeStart + 1, typeEnd - typeStart);
        run.m_type = this.getTypeIdFor(type);
        if (index < pattern.length && pattern[index] == ':') {
            ++index;
            while (index < pattern.length && pattern[index] != '}') {
                ++index;
            }
            int length = index - typeEnd - 2;
            if (length != 0) {
                run.m_format = new String(pattern, typeEnd + 2, length);
            }
        }
        if (index >= pattern.length || '}' != pattern[index]) {
            throw new IllegalArgumentException("Unterminated type in pattern at character " + index);
        }
        stack.push(run);
        return ++index - start;
    }

    private final int addTextRun(Stack stack, char[] pattern, int index) {
        PatternRun run = new PatternRun();
        int start = index;
        boolean escapeMode = false;
        if ('%' == pattern[index]) {
            ++index;
        }
        StringBuffer sb = new StringBuffer();
        while (index < pattern.length && pattern[index] != '%') {
            if (escapeMode) {
                if ('n' == pattern[index]) {
                    sb.append(EOL);
                } else if ('t' == pattern[index]) {
                    sb.append('\t');
                } else {
                    sb.append(pattern[index]);
                }
                escapeMode = false;
            } else if ('\\' == pattern[index]) {
                escapeMode = true;
            } else {
                sb.append(pattern[index]);
            }
            ++index;
        }
        run.m_data = sb.toString();
        run.m_type = 1;
        stack.push(run);
        return index - start;
    }

    private final void append(StringBuffer sb, int minSize, int maxSize, boolean rightJustify, String output) {
        int size = output.length();
        if (size < minSize) {
            if (rightJustify) {
                this.appendWhiteSpace(sb, minSize - size);
                sb.append(output);
            } else {
                sb.append(output);
                this.appendWhiteSpace(sb, minSize - size);
            }
        } else if (maxSize > 0 && maxSize < size) {
            if (rightJustify) {
                sb.append(output.substring(size - maxSize));
            } else {
                sb.append(output.substring(0, maxSize));
            }
        } else {
            sb.append(output);
        }
    }

    private final void appendWhiteSpace(StringBuffer sb, int length) {
        while (length >= 16) {
            sb.append(SPACE_16);
            length -= 16;
        }
        if (length >= 8) {
            sb.append(SPACE_8);
            length -= 8;
        }
        if (length >= 4) {
            sb.append(SPACE_4);
            length -= 4;
        }
        if (length >= 2) {
            sb.append(SPACE_2);
            length -= 2;
        }
        if (length >= 1) {
            sb.append(SPACE_1);
            --length;
        }
    }

    public String format(LogEvent event) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.m_formatSpecification.length) {
            PatternRun run = this.m_formatSpecification[i];
            if (run.m_type == 1) {
                sb.append(run.m_data);
            } else {
                String data = this.formatPatternRun(event, run);
                if (data != null) {
                    this.append(sb, run.m_minSize, run.m_maxSize, run.m_rightJustify, data);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    protected String formatPatternRun(LogEvent event, PatternRun run) {
        switch (run.m_type) {
            case 6: {
                return this.getRTime(event.getRelativeTime(), run.m_format);
            }
            case 5: {
                return this.getTime(event.getTime(), run.m_format);
            }
            case 7: {
                return this.getStackTrace(event.getThrowable(), run.m_format);
            }
            case 4: {
                return this.getMessage(event.getMessage(), run.m_format);
            }
            case 2: {
                return this.getCategory(event.getCategory(), run.m_format);
            }
            case 8: {
                return this.getPriority(event.getPriority(), run.m_format);
            }
            case 3: {
                if (run.m_format == null || run.m_format.startsWith("stack")) {
                    return this.getContext(event.getContextStack(), run.m_format);
                }
                return this.getContextMap(event.getContextMap(), run.m_format);
            }
            case 9: {
                return this.getThread(run.m_format);
            }
        }
        throw new IllegalStateException("Unknown Pattern specification." + run.m_type);
    }

    protected String getCategory(String category, String format) {
        return category;
    }

    protected String getPriority(Priority priority, String format) {
        return priority.getName();
    }

    protected String getThread(String format) {
        return Thread.currentThread().getName();
    }

    protected String getContext(ContextStack stack, String format) {
        return this.getContextStack(stack, format);
    }

    protected String getContextStack(ContextStack stack, String format) {
        if (stack == null) {
            return "";
        }
        return stack.toString(Integer.MAX_VALUE);
    }

    protected String getContextMap(ContextMap map, String format) {
        if (map == null) {
            return "";
        }
        return map.get(format, "").toString();
    }

    protected String getMessage(String message, String format) {
        return message;
    }

    protected String getStackTrace(Throwable throwable, String format) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    protected String getRTime(long time, String format) {
        return this.getTime(time, format);
    }

    protected String getTime(long time, String format) {
        if (format == null) {
            return Long.toString(time);
        }
        Date date = this.m_date;
        synchronized (date) {
            if (this.m_simpleDateFormat == null) {
                this.m_simpleDateFormat = new SimpleDateFormat(format);
            }
            this.m_date.setTime(time);
            return this.m_simpleDateFormat.format(this.m_date);
        }
    }

    protected int getTypeIdFor(String type) {
        if (type.equalsIgnoreCase(TYPE_CATEGORY_STR)) {
            return 2;
        }
        if (type.equalsIgnoreCase(TYPE_CONTEXT_STR)) {
            return 3;
        }
        if (type.equalsIgnoreCase(TYPE_MESSAGE_STR)) {
            return 4;
        }
        if (type.equalsIgnoreCase(TYPE_PRIORITY_STR)) {
            return 8;
        }
        if (type.equalsIgnoreCase(TYPE_TIME_STR)) {
            return 5;
        }
        if (type.equalsIgnoreCase(TYPE_RELATIVE_TIME_STR)) {
            return 6;
        }
        if (type.equalsIgnoreCase(TYPE_THREAD_STR)) {
            return 9;
        }
        if (type.equalsIgnoreCase(TYPE_THROWABLE_STR)) {
            return 7;
        }
        throw new IllegalArgumentException("Unknown Type in pattern - " + type);
    }

    protected final void parse(String patternString) {
        Stack stack = new Stack();
        int size = patternString.length();
        char[] pattern = new char[size];
        int index = 0;
        patternString.getChars(0, size, pattern, 0);
        while (index < size) {
            if (pattern[index] == '%' && (index == size - 1 || pattern[index + 1] != '%')) {
                index += this.addPatternRun(stack, pattern, index);
                continue;
            }
            index += this.addTextRun(stack, pattern, index);
        }
        int elementCount = stack.size();
        this.m_formatSpecification = new PatternRun[elementCount];
        int i = 0;
        while (i < elementCount) {
            this.m_formatSpecification[i] = (PatternRun)stack.elementAt(i);
            ++i;
        }
    }

    public void setFormat(String format) {
        this.parse(format);
    }

    public PatternFormatter() {
    }

    public PatternFormatter(String pattern) {
        this.parse(pattern);
    }

    protected static class PatternRun {
        public String m_data;
        public boolean m_rightJustify;
        public int m_minSize;
        public int m_maxSize;
        public int m_type;
        public String m_format;

        PatternRun() {
        }
    }
}

