/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io.rotate;

import java.io.File;
import java.io.IOException;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;
import org.apache.log.output.io.rotate.FileStrategy;
import org.apache.log.output.io.rotate.RotateStrategy;

public class RotatingFileTarget
extends FileTarget {
    private boolean m_append;
    private RotateStrategy m_rotateStrategy;
    private FileStrategy m_fileStrategy;

    protected synchronized void rotate() throws IOException {
        this.close();
        File file = this.m_fileStrategy.nextFile();
        this.setFile(file, this.m_append);
        this.openFile();
    }

    protected synchronized void write(String data) {
        if (this.m_rotateStrategy.isRotationNeeded(data, this.getFile())) {
            try {
                this.rotate();
                this.m_rotateStrategy.reset();
            }
            catch (IOException ioe) {
                this.getErrorHandler().error("Error rotating file", ioe, null);
            }
        }
        super.write(data);
    }

    public RotatingFileTarget(Formatter formatter, RotateStrategy rotateStrategy, FileStrategy fileStrategy) throws IOException {
        this(false, formatter, rotateStrategy, fileStrategy);
    }

    public RotatingFileTarget(boolean append, Formatter formatter, RotateStrategy rotateStrategy, FileStrategy fileStrategy) throws IOException {
        super(null, append, formatter);
        this.m_append = append;
        this.m_rotateStrategy = rotateStrategy;
        this.m_fileStrategy = fileStrategy;
        this.rotate();
    }
}

