/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.lf5;

import java.util.Arrays;
import java.util.List;
import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.util.StackIntrospector;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogRecord;

public class LogKitLogRecord
extends LogRecord {
    public static final List LOGKIT_LOGLEVELS = Arrays.asList(LogLevel.FATAL, LogLevel.ERROR, LogLevel.WARN, LogLevel.INFO, LogLevel.DEBUG);
    private boolean m_severe;
    private static /* synthetic */ Class class$Lorg$apache$log$Logger;

    public boolean isSevereLevel() {
        return this.m_severe;
    }

    public LogLevel toLogLevel(Priority priority) {
        if (Priority.DEBUG == priority) {
            return LogLevel.DEBUG;
        }
        if (Priority.INFO == priority) {
            return LogLevel.INFO;
        }
        if (Priority.WARN == priority) {
            return LogLevel.WARN;
        }
        if (Priority.ERROR == priority) {
            return LogLevel.ERROR;
        }
        if (Priority.FATAL_ERROR == priority) {
            return LogLevel.FATAL;
        }
        return new LogLevel(priority.getName(), priority.getValue());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public LogKitLogRecord(LogEvent event, Formatter fmt) {
        Object contextObject;
        Object object;
        ContextMap contextMap = event.getContextMap();
        this.setCategory(event.getCategory());
        this.setLevel(this.toLogLevel(event.getPriority()));
        this.m_severe = event.getPriority().isGreater(Priority.INFO);
        if (contextMap != null && (object = contextMap.get("method")) != null) {
            this.setLocation(object.toString());
        } else {
            this.setLocation(StackIntrospector.getCallerMethod(class$Lorg$apache$log$Logger != null ? class$Lorg$apache$log$Logger : (class$Lorg$apache$log$Logger = LogKitLogRecord.class$("org.apache.log.Logger"))));
        }
        this.setMessage(event.getMessage());
        this.setMillis(event.getTime());
        this.setNDC(fmt.format(event));
        if (contextMap != null && (contextObject = contextMap.get("thread")) != null) {
            this.setThreadDescription(contextObject.toString());
        } else {
            this.setThreadDescription(Thread.currentThread().getName());
        }
        this.setThrown(event.getThrowable());
    }
}

