/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public final class StackIntrospector {
    private static CallStack c_callStack;

    private static final synchronized CallStack getCallStack() throws SecurityException {
        if (c_callStack == null) {
            c_callStack = new CallStack();
        }
        return c_callStack;
    }

    public static final Class getCallerClass(Class clazz) throws SecurityException {
        return StackIntrospector.getCallerClass(clazz, 0);
    }

    public static final Class getCallerClass(Class clazz, int stackDepthOffset) {
        Class[] stack = StackIntrospector.getCallStack().get();
        int i = stack.length - 1;
        while (i >= 0) {
            if (clazz.isAssignableFrom(stack[i])) {
                return stack[i + 1 + stackDepthOffset];
            }
            --i;
        }
        return null;
    }

    public static final String getCallerMethod(Class clazz) {
        String className = clazz.getName();
        StringWriter sw = new StringWriter();
        Throwable throwable = new Throwable();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        StringBuffer buffer = sw.getBuffer();
        StringBuffer line = new StringBuffer();
        int length = buffer.length();
        boolean found = false;
        int state = 0;
        int i = 0;
        while (i < length) {
            char ch = buffer.charAt(i);
            switch (state) {
                case 0: {
                    if ('\n' != ch) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if ('t' != ch) break;
                    state = 2;
                    break;
                }
                case 2: {
                    line.setLength(0);
                    state = 3;
                    break;
                }
                case 3: {
                    if ('\n' != ch) {
                        line.append(ch);
                        break;
                    }
                    String method = line.toString();
                    boolean match = method.startsWith(className);
                    if (!found && match) {
                        found = true;
                    } else if (found && !match) {
                        return method;
                    }
                    state = 1;
                }
            }
            ++i;
        }
        return "";
    }

    public static final String getRecentStack(Class clazz, int entries) {
        String className = clazz.getName();
        StringWriter sw = new StringWriter();
        Throwable throwable = new Throwable();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        StringBuffer buffer = sw.getBuffer();
        StringBuffer line = new StringBuffer();
        StringBuffer stack = new StringBuffer();
        int length = buffer.length();
        boolean found = false;
        int state = 0;
        int i = 0;
        while (i < length) {
            char ch = buffer.charAt(i);
            switch (state) {
                case 0: {
                    if ('\n' != ch) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if ('t' != ch) break;
                    state = 2;
                    break;
                }
                case 2: {
                    line.setLength(0);
                    state = 3;
                    break;
                }
                case 3: {
                    if ('\n' != ch) {
                        line.append(ch);
                        break;
                    }
                    String method = line.toString();
                    boolean match = method.startsWith(className);
                    if (!found && match) {
                        found = true;
                    } else if (found && !match) {
                        stack.append(method);
                        if (--entries == 0) {
                            return stack.toString();
                        }
                        stack.append("\n");
                    }
                    state = 1;
                }
            }
            ++i;
        }
        return "";
    }

    private StackIntrospector() {
    }

    private static final class CallStack
    extends SecurityManager {
        public final Class[] get() {
            return this.getClassContext();
        }

        CallStack() {
        }
    }
}

