/*
 * Decompiled with CFR 0.152.
 */
import com.fujitsu.xml.omquery.DomQueryMgr;
import com.jclark.xsl.dom.SunXMLProcessorImpl;
import com.jclark.xsl.om.XSLException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.jutils.time.StopWatch;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DomQueryTest {
    final String ME = "DomQueryTester";
    boolean testAgentNavigation = true;

    public DomQueryTest(String[] argv) {
        String tmp = System.getProperty("testAgentNavigation");
        if (tmp != null) {
            this.testAgentNavigation = Boolean.valueOf(tmp);
        }
        if (argv.length < 2) {
            System.out.println("Usage:\n\n   java DomQueryTest <XML-file> <Query-String>\n\nExample:\n   java DomQueryTest Agent.xml xmlBlaster/key/AGENT[@id=\\\"192.168.124.10\\\"]\n");
            System.exit(1);
        }
        boolean dumpIt = false;
        if (argv.length == 2) {
            dumpIt = true;
        }
        try {
            StopWatch queryTime2;
            int num_nodes;
            Enumeration iter;
            StopWatch queryTime;
            StopWatch inputTime = new StopWatch();
            InputSource input = new InputSource(this.createURL(argv[0]));
            System.out.println("Read file" + inputTime.nice());
            StopWatch xmlprocTime = new StopWatch();
            SunXMLProcessorImpl xmlproc = new SunXMLProcessorImpl();
            System.out.println("Instantiate SunXMLProcessorImpl" + xmlprocTime.nice());
            StopWatch docTime = new StopWatch();
            Document doc = xmlproc.load(input);
            System.out.println("Create DOM - Document" + docTime.nice());
            StopWatch mgrTime = new StopWatch();
            DomQueryMgr query_mgr = new DomQueryMgr(doc);
            System.out.println("Instantiate DomQueryMgr" + mgrTime.nice());
            if (argv.length > 1) {
                queryTime = new StopWatch();
                iter = query_mgr.getNodesByXPath(doc, argv[1]);
                System.out.println("Query time" + queryTime.nice());
                num_nodes = this.getNumNodes(iter, dumpIt);
                System.out.println(num_nodes + " nodes matches for XPath " + "\"" + argv[1] + "\"");
            }
            if (dumpIt) {
                queryTime = new StopWatch();
                iter = query_mgr.getNodesByXPath(doc, argv[1]);
                System.out.println("Query a second time encreases performance to" + queryTime.nice());
                System.exit(0);
            }
            if (argv.length > 2) {
                queryTime2 = new StopWatch();
                iter = query_mgr.getNodesByXPath(doc, argv[2]);
                System.out.println("Query time" + queryTime2.nice());
                num_nodes = this.getNumNodes(iter, dumpIt);
                System.out.println(num_nodes + " nodes matches for XPath " + "\"" + argv[2] + "\"");
            }
            if (argv.length > 3) {
                queryTime2 = new StopWatch();
                iter = query_mgr.getNodesByXPath(doc, argv[3]);
                System.out.println("Query time" + queryTime2.nice());
                num_nodes = this.getNumNodes(iter, dumpIt);
                System.out.println(num_nodes + " nodes matches for XPath " + "\"" + argv[3] + "\"");
            }
            docTime = new StopWatch();
            doc = xmlproc.load(input);
            System.out.println("Create DOM - Document" + docTime.nice());
            mgrTime = new StopWatch();
            query_mgr = new DomQueryMgr(doc);
            System.out.println("Instantiate DomQueryMgr" + mgrTime.nice());
            if (argv.length > 1) {
                queryTime = new StopWatch();
                iter = query_mgr.getNodesByXPath(doc, argv[1]);
                System.out.println("Query time" + queryTime.nice());
                num_nodes = this.getNumNodes(iter, dumpIt);
                System.out.println(num_nodes + " nodes matches for XPath " + "\"" + argv[1] + "\"");
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        catch (SAXException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        catch (XSLException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private int getNumNodes(Enumeration nodeIter, boolean dumpIt) throws XSLException {
        int n = 0;
        while (nodeIter.hasMoreElements()) {
            ++n;
            Object obj = nodeIter.nextElement();
            if (!dumpIt) continue;
            if (obj instanceof String) {
                String val = (String)obj;
                System.out.println("TagValue=" + val);
            } else {
                System.out.println(obj.toString());
            }
            if (!this.testAgentNavigation) continue;
            try {
                Element node = (Element)obj;
                System.out.println("Found key oid=\"" + this.getKeyOID(node) + "\"\n");
            }
            catch (Exception e) {
                System.out.println("ERROR: Found no xmlBlaster key oid. " + e.toString());
            }
        }
        return n;
    }

    private String getKeyOID(Node node) throws Exception {
        if (node == null) {
            throw new Exception("no parent node found");
        }
        String nodeName = node.getNodeName();
        if (nodeName.equals("xmlBlaster")) {
            throw new Exception("xmlBlaster node not allowed");
        }
        if (!nodeName.equals("key")) {
            return this.getKeyOID(node.getParentNode());
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && attributes.getLength() > 0) {
            int attributeCount = attributes.getLength();
            int i = 0;
            while (i < attributeCount) {
                Attr attribute = (Attr)attributes.item(i);
                if (attribute.getNodeName().equals("oid")) {
                    String val = attribute.getNodeValue();
                    return val;
                }
                ++i;
            }
        }
        throw new Exception("Internal getKeyOID() error");
    }

    private String createURL(String path) {
        File f = new File(path);
        String uri = f.getAbsolutePath();
        char sep = System.getProperty("file.separator").charAt(0);
        if ((uri = uri.replace(sep, '/')).charAt(0) != '/') {
            uri = '/' + uri;
        }
        uri = "file://" + uri;
        return uri;
    }

    public static void main(String[] argv) {
        new DomQueryTest(argv);
    }
}

