/*
 * Decompiled with CFR 0.152.
 */
package http.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.TextArea;
import java.util.Hashtable;
import org.xmlBlaster.client.protocol.http.applet.XmlBlasterAccessRaw;
import org.xmlBlaster.client.protocol.http.common.I_CallbackRaw;
import org.xmlBlaster.client.protocol.http.common.I_XmlBlasterAccessRaw;

public class SystemInfoApplet
extends Applet
implements I_CallbackRaw {
    I_XmlBlasterAccessRaw xmlBlasterAccess;
    TextArea textArea;
    boolean runAsApplet;

    public void init() {
        this.runAsApplet = true;
        System.out.println("SystemInfoApplet: Applet.init() called");
        try {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
            this.textArea = new TextArea("", 12, 60);
            this.textArea.setBackground(Color.white);
            this.textArea.setForeground(Color.black);
            this.add(this.textArea);
            this.repaint();
            this.xmlBlasterAccess = new XmlBlasterAccessRaw(this);
            this.xmlBlasterAccess.connect(null, this);
            this.print("Connected to xmlBlaster");
            Hashtable subReturnQos = this.xmlBlasterAccess.subscribe("<key oid='cpuinfo'/>", "<qos/>");
            subReturnQos = this.xmlBlasterAccess.subscribe("<key oid='meminfo'/>", "<qos/>");
            this.print("Subscribed on 'cpuinfo' and 'meminfo' topics");
            this.showStatus("SystemInfoApplet: Connected to xmlBlaster");
        }
        catch (Exception e) {
            this.print("No connection to xmlBlaster: " + e.toString());
            e.printStackTrace();
            this.showStatus("SystemInfoApplet: No connection to xmlBlaster: " + e.toString());
        }
    }

    public void init(Hashtable properties) {
        try {
            this.xmlBlasterAccess = new XmlBlasterAccessRaw(properties);
            this.xmlBlasterAccess.connect(null, this);
            Hashtable subReturnQos = this.xmlBlasterAccess.subscribe("<key oid='cpuinfo'/>", "<qos/>");
            subReturnQos = this.xmlBlasterAccess.subscribe("<key oid='meminfo'/>", "<qos/>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void print(String text) {
        if (this.runAsApplet) {
            this.textArea.append("SystemInfoApplet: " + text + "\n");
        } else {
            System.out.println("SystemInfo: " + text + "\n");
        }
    }

    public void destroy() {
        this.print("Applet destroy ...");
        if (this.xmlBlasterAccess != null) {
            try {
                this.xmlBlasterAccess.unSubscribe("<key oid='cpuinfo'/>", "<qos/>");
                this.xmlBlasterAccess.unSubscribe("<key oid='meminfo'/>", "<qos/>");
            }
            catch (Exception e) {
                this.print("UnSubscribe problem: " + e.toString());
            }
            this.xmlBlasterAccess.disconnect("<qos/>");
            this.xmlBlasterAccess = null;
            this.print("Disconnected from xmlBlaster");
        }
    }

    public String update(String cbSessionId, Hashtable updateKey, byte[] content, Hashtable updateQos) throws Exception {
        this.print("Asynchronous Update: key=" + updateKey.get("/key/@oid") + "=" + new String(content));
        return "<qos/>";
    }

    public static void main(String[] args) {
        SystemInfoApplet appl = new SystemInfoApplet();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (args.length < 1) {
            properties.put("xmlBlaster/servletUrl", "http://localhost:8080/xmlBlaster/AppletServlet");
        } else {
            properties.put("xmlBlaster/servletUrl", args[0]);
        }
        properties.put("xmlBlaster/logLevels", "ERROR,WARN,INFO");
        appl.init(properties);
    }
}

