/*
 * Decompiled with CFR 0.152.
 */
package http.applet;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import org.xmlBlaster.client.protocol.http.applet.XmlBlasterAccessRaw;
import org.xmlBlaster.client.protocol.http.common.I_CallbackRaw;
import org.xmlBlaster.client.protocol.http.common.I_XmlBlasterAccessRaw;

public class XmlScript
extends Applet
implements I_CallbackRaw,
ActionListener {
    I_XmlBlasterAccessRaw xmlBlasterAccess;
    TextArea textArea;
    TextArea requestArea;
    Button connectButton;
    Button sendButton;
    boolean runAsApplet;

    public void init() {
        this.runAsApplet = true;
        System.out.println("XmlScript: Applet.init() called");
        try {
            this.initUI();
        }
        catch (Exception e) {
            this.showStatus("XmlScript: Problem in init(): " + e.toString());
        }
    }

    private void initUI() throws Exception {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.connectButton = new Button("Connect");
        this.connectButton.setActionCommand("connect");
        this.connectButton.addActionListener(this);
        this.add(this.connectButton);
        this.sendButton = new Button("Send");
        this.sendButton.setActionCommand("send");
        this.sendButton.addActionListener(this);
        this.add(this.sendButton);
        this.requestArea = new TextArea("", 9, 62);
        this.requestArea.setBackground(Color.white);
        this.requestArea.setForeground(Color.black);
        this.requestArea.setText("<xmlBlaster>\n  <get>\n    <key queryType='XPATH'>\n      /xmlBlaster/key\n    </key>\n  </get>\n</xmlBlaster>\n<!-- See http://www.xmlblaster.org/xmlBlaster/doc/requirements/client.script.html -->");
        this.add(this.requestArea);
        this.textArea = new TextArea("", 24, 80);
        this.textArea.setBackground(Color.white);
        this.textArea.setForeground(Color.black);
        this.add(this.textArea);
        this.repaint();
    }

    public void actionPerformed(ActionEvent ev) {
        String command = ev.getActionCommand();
        Object obj = ev.getSource();
        try {
            if (command.equals("connect")) {
                if (this.connectButton.getLabel().equals("Connect")) {
                    this.xmlBlasterAccess = new XmlBlasterAccessRaw(this);
                    this.xmlBlasterAccess.connect(null, this);
                    this.print("Connected to xmlBlaster");
                    this.showStatus("XmlScript: Connected to xmlBlaster, please send a request.");
                    this.connectButton.setLabel("Logout");
                } else if (this.connectButton.getLabel().equals("Logout")) {
                    this.xmlBlasterAccess.disconnect(null);
                    this.xmlBlasterAccess = null;
                    this.showStatus("XmlScript: Not connected to xmlBlaster.");
                    this.connectButton.setLabel("Connect");
                }
            } else if (command.equals("send") || ev.getSource() instanceof TextField) {
                if (this.xmlBlasterAccess == null || !this.xmlBlasterAccess.isConnected()) {
                    this.showStatus("XmlScript: Please log in first.");
                    return;
                }
                String xmlRequest = this.requestArea.getText();
                String response = this.xmlBlasterAccess.sendXmlScript(xmlRequest);
                this.textArea.setText(this.textArea.getText() + response);
                this.showStatus("XmlScript: Request done.");
            }
        }
        catch (Exception e) {
            this.print(e.toString());
            e.printStackTrace();
            this.showStatus("XmlScript: " + e.toString());
        }
    }

    public void init(Hashtable properties) {
        try {
            this.xmlBlasterAccess = new XmlBlasterAccessRaw(properties);
            this.xmlBlasterAccess.connect(null, this);
            Hashtable subReturnQos = this.xmlBlasterAccess.subscribe("<key oid='cpuinfo'/>", "<qos/>");
            subReturnQos = this.xmlBlasterAccess.subscribe("<key oid='meminfo'/>", "<qos/>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void print(String text) {
        if (this.runAsApplet) {
            this.textArea.append("XmlScript: " + text + "\n");
        } else {
            System.out.println("SystemInfo: " + text + "\n");
        }
    }

    public void destroy() {
        this.print("Applet destroy ...");
        if (this.xmlBlasterAccess != null) {
            try {
                this.xmlBlasterAccess.unSubscribe("<key oid='cpuinfo'/>", "<qos/>");
                this.xmlBlasterAccess.unSubscribe("<key oid='meminfo'/>", "<qos/>");
            }
            catch (Exception e) {
                this.print("UnSubscribe problem: " + e.toString());
            }
            this.xmlBlasterAccess.disconnect("<qos/>");
            this.xmlBlasterAccess = null;
            this.print("Disconnected from xmlBlaster");
        }
    }

    public String update(String cbSessionId, Hashtable updateKey, byte[] content, Hashtable updateQos) throws Exception {
        this.print("Asynchronous update arrived: key=" + updateKey.get("/key/@oid") + ", status=" + updateQos.get("/qos/state/@id") + ":");
        this.print("------------------------------------------------");
        this.print(new String(content));
        this.print("------------------------------------------------");
        return "<qos/>";
    }

    public static void main(String[] args) {
        XmlScript appl = new XmlScript();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (args.length < 1) {
            properties.put("xmlBlaster/servletUrl", "http://localhost:8080/xmlBlaster/AppletServlet");
        } else {
            properties.put("xmlBlaster/servletUrl", args[0]);
        }
        properties.put("xmlBlaster/logLevels", "ERROR,WARN,INFO");
        appl.init(properties);
    }
}

