/*
 * Decompiled with CFR 0.152.
 */
package http.dhtml.systemInfo;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.protocol.http.BlasterHttpProxy;
import org.xmlBlaster.protocol.http.HttpPushHandler;
import org.xmlBlaster.protocol.http.Util;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class SystemInfo
extends HttpServlet {
    private static final String ME = "SystemInfo";
    private LogChannel log = null;

    public void init(ServletConfig conf) throws ServletException {
        super.init(conf);
        this.log = Global.instance().getLog("http");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.log.CALL) {
            this.log.call(ME, "Entering SystemInfo.doRequest() ...");
        }
        StopWatch stop = new StopWatch();
        String sessionId = request.getRequestedSessionId();
        String actionType = Util.getParameter(request, "ActionType", null);
        String output = "Subscribing to " + actionType + " message ...";
        try {
            if (actionType == null) {
                String str = "Please call servlet with some ActionType e.g. xmlBlaster/dhtml/systemInfo?ActionType=cpuinfo";
                this.log.error(ME, str);
                this.htmlOutput(str, response);
                return;
            }
            I_XmlBlasterAccess corbaConnection = BlasterHttpProxy.getXmlBlasterAccess(sessionId);
            if (corbaConnection == null) {
                String text = "Your Session ID is not valid, please try again with cookies enabled";
                this.log.error(ME, text);
                this.popupError(response, text);
                return;
            }
            this.log.info(ME, "Got request for " + actionType + ", sessionId=" + sessionId + " ...");
            SubscribeKey xmlKey = new SubscribeKey(null, actionType);
            SubscribeQos xmlQos = new SubscribeQos(null);
            String ret = corbaConnection.subscribe(xmlKey.toXml(), xmlQos.toXml()).getSubscriptionId();
            this.log.info(ME, "Subscribed to " + actionType + "=" + ret);
        }
        catch (XmlBlasterException e) {
            String text = "Error from xmlBlaster: " + e.getMessage();
            this.log.error(ME, text);
            this.popupError(response, text);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(ME, "Error in doGet(): " + e.toString());
            this.popupError(response, e.toString());
            return;
        }
        this.htmlOutput(output, response);
        this.log.trace(ME, "Leaving SystemInfo.doRequest() ..." + stop.nice());
        System.gc();
    }

    public void htmlOutput(String htmlData, HttpServletResponse response) throws ServletException {
        response.setContentType("text/html");
        try {
            PrintWriter pw = response.getWriter();
            pw.println(htmlData);
            pw.close();
        }
        catch (IOException e) {
            this.log.warn(ME, "Could not deliver HTML page to browser:" + e.toString());
            throw new ServletException(e.toString());
        }
    }

    public void popupError(HttpServletResponse response, String error) {
        try {
            response.setContentType("text/html");
            PrintWriter pw = response.getWriter();
            pw.println(HttpPushHandler.alert(error));
            pw.close();
        }
        catch (IOException e) {
            this.log.error(ME, "Sending of error failed: " + error + "\n Reason=" + e.toString());
        }
    }

    public void xmlOutput(String xmlData, HttpServletResponse response) throws ServletException {
        response.setContentType("text/xml");
        try {
            PrintWriter pw = response.getWriter();
            pw.println(xmlData);
            pw.close();
        }
        catch (IOException e) {
            PrintWriter pw;
            String text = "Sending XML data to browser failed: " + e.toString();
            this.log.warn(ME, text);
            try {
                pw = response.getWriter();
            }
            catch (IOException e2) {
                this.log.error(ME, "2.xml send problem");
                return;
            }
            pw.println("<html><body>Request Problems" + text + "</body></html>");
            pw.close();
        }
    }
}

