/*
 * Decompiled with CFR 0.152.
 */
package http.dhtml.systemInfo;

import java.util.Random;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class SystemInfoPublisher {
    private static final String ME = "SystemInfoPublisher";
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess con;
    private Random random = new Random();

    public SystemInfoPublisher(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("client");
        this.setUp();
        while (true) {
            try {
                int val = this.random.nextInt(6000);
                if (val < 2000) {
                    val = 2000;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(val);
                }
                catch (InterruptedException i) {
                    // empty catch block
                }
                int cpu = this.getCpuload();
                this.publish("cpuinfo", cpu);
                val = this.random.nextInt(6000);
                if (val < 2000) {
                    val = 2000;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(val);
                }
                catch (InterruptedException i) {
                    // empty catch block
                }
                int mem = this.getMeminfo();
                this.publish("meminfo", mem);
                continue;
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, e.getMessage());
                continue;
            }
            break;
        }
    }

    private int getCpuload() throws XmlBlasterException {
        return this.random.nextInt(100);
    }

    private int getMeminfo() throws XmlBlasterException {
        int val = this.random.nextInt(100);
        if (val < 11) {
            val = 11;
        }
        if (val > 96) {
            val = 96;
        }
        return val;
    }

    private void setUp() {
        try {
            this.con = this.glob.getXmlBlasterAccess();
            this.con.connect(null, null);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    private void tearDown() {
        this.con.disconnect(null);
    }

    private void publish(String oid, int value) {
        if (this.con == null) {
            return;
        }
        String content = "" + value;
        PublishKey key = new PublishKey(this.glob, oid, "text/plain", "systemInfo");
        key.setClientTags("<systemInfo />");
        PublishQos qos = new PublishQos(this.glob);
        MsgUnit msgUnit = new MsgUnit(key, content.getBytes(), qos);
        try {
            this.con.publish(msgUnit);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
        }
        this.log.info(ME, "Published message " + oid + " with value " + content);
    }

    public static void main(String[] args) {
        new SystemInfoPublisher(new Global(args));
    }
}

