/*
 * Decompiled with CFR 0.152.
 */
package javaclients;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.GetReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.client.qos.UpdateReturnQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class AllProtocols
implements I_Callback {
    private String ME = "";
    private final Global glob;
    private final LogChannel log;
    private final String[] argsIOR = new String[]{"-protocol", "IOR"};
    private final String[] argsSocket = new String[]{"-protocol", "SOCKET"};
    private final String[] argsXmlRpc = new String[]{"-protocol", "XMLRPC"};
    private final String[] argsRmi = new String[]{"-protocol", "RMI"};
    private final Con[] conList = new Con[]{new Con(this.argsIOR, "IOR connection"), new Con(this.argsSocket, "SOCKET connection"), new Con(this.argsXmlRpc, "XMLRPC connection"), new Con(this.argsRmi, "RMI connection")};

    public AllProtocols(Global glob) {
        this.glob = glob;
        this.log = glob.getLog(null);
        int i = 0;
        while (i < this.conList.length) {
            this.ME = this.conList[i].helpText;
            I_XmlBlasterAccess con = this.conList[i].con = this.conList[i].glob.getXmlBlasterAccess();
            try {
                String name = con.getGlobal().getProperty().get("session.name", "AllProtocols");
                String passwd = con.getGlobal().getProperty().get("passwd", "secret");
                ConnectQos qos = new ConnectQos(con.getGlobal(), name, passwd);
                con.connect(qos, this);
                PublishKey pk = new PublishKey(con.getGlobal(), "AllProtocols", "text/xml", "1.0");
                pk.setClientTags("<org.xmlBlaster><demo/></org.xmlBlaster>");
                PublishQos pq = new PublishQos(con.getGlobal());
                MsgUnit msgUnit = new MsgUnit(pk, "Hi", pq);
                con.publish(msgUnit);
                GetKey gk = new GetKey(con.getGlobal(), "AllProtocols");
                GetQos gq = new GetQos(con.getGlobal());
                MsgUnit[] msgs = con.get(gk.toXml(), gq.toXml());
                GetReturnQos grq = new GetReturnQos(con.getGlobal(), msgs[0].getQos());
                this.log.info(this.ME, "Accessed xmlBlaster message with content '" + new String(msgs[0].getContent()) + "' and status=" + grq.getState());
                SubscribeKey sk = new SubscribeKey(con.getGlobal(), "AllProtocols");
                SubscribeQos sq = new SubscribeQos(con.getGlobal());
                SubscribeReturnQos subRet = con.subscribe(sk.toXml(), sq.toXml());
                msgUnit = new MsgUnit(pk, "Ho".getBytes(), pq);
                PublishReturnQos prq = con.publish(msgUnit);
                this.log.info(this.ME, "Got status='" + prq.getState() + "' for published message '" + prq.getKeyOid());
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                UnSubscribeKey uk = new UnSubscribeKey(con.getGlobal(), subRet.getSubscriptionId());
                UnSubscribeQos uq = new UnSubscribeQos(con.getGlobal());
                UnSubscribeReturnQos[] urq = con.unSubscribe(uk.toXml(), uq.toXml());
                EraseKey ek = new EraseKey(con.getGlobal(), "AllProtocols");
                EraseQos eq = new EraseQos(con.getGlobal());
                EraseReturnQos[] eraseArr = con.erase(ek.toXml(), eq.toXml());
                DisconnectQos dq = new DisconnectQos(con.getGlobal());
                con.disconnect(dq);
            }
            catch (XmlBlasterException e) {
                this.log.error(this.ME, e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.log.error(this.ME, e.toString());
            }
            ++i;
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        if (updateKey.isInternal()) {
            this.log.info("", "Received unexpected internal message '" + updateKey.getOid() + " from xmlBlaster");
            return "";
        }
        this.log.info(this.ME, "Received asynchronous message '" + updateKey.getOid() + "' state=" + updateQos.getState() + " content=" + new String(content) + " from xmlBlaster");
        UpdateReturnQos uq = new UpdateReturnQos(updateKey.getGlobal());
        return uq.toXml();
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            System.err.println("Example: java javaclients.AllProtocols -session.name Jeff\n");
            System.exit(1);
        }
        new AllProtocols(glob);
    }

    class Con {
        public String helpText;
        public Global glob;
        public I_XmlBlasterAccess con;

        public Con(String[] args, String helpText) {
            this.glob = new Global(args, true, false);
            this.helpText = helpText;
        }
    }
}

