/*
 * Decompiled with CFR 0.152.
 */
package javaclients;

import org.jutils.JUtilsException;
import org.jutils.init.Args;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class ClientQuery {
    private static String ME = "ClientQuery";
    private final LogChannel log;
    private String queryString;
    private String queryType = "XPATH";

    public ClientQuery(String[] args) {
        Global glob = new Global();
        this.log = glob.getLog(null);
        if (glob.init(args) != 0) {
            this.usage("Aborted");
        }
        try {
            String loginName = Args.getArg(args, "-session.name", ME);
            String passwd = Args.getArg(args, "-passwd", "secret");
            this.queryString = Args.getArg(args, "-queryXpath", (String)null);
            if (this.queryString != null) {
                this.queryType = "XPATH";
            } else {
                this.usage("Please enter a query string");
            }
            I_XmlBlasterAccess con = glob.getXmlBlasterAccess();
            con.connect(null, null);
            String xmlKey = "<key oid='' queryType='" + this.queryType + "'>\n" + this.queryString + "</key>";
            MsgUnit[] msgArr = null;
            try {
                msgArr = con.get(xmlKey, "<qos></qos>");
                this.log.info(ME, "Got " + msgArr.length + " messages for query '" + this.queryString + "':");
                int ii = 0;
                while (ii < msgArr.length) {
                    UpdateKey updateKey = new UpdateKey(glob, msgArr[ii].getKey());
                    this.log.info("UpdateKey", "\n" + updateKey.toXml());
                    this.log.info("content", "\n" + new String(msgArr[ii].getContent()) + "\n");
                    ++ii;
                }
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "XmlBlasterException: " + e.getMessage());
            }
            con.disconnect(null);
        }
        catch (JUtilsException e) {
            this.log.error(ME, "Error occurred: " + e.toString());
            e.printStackTrace();
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "Error occurred: " + e.toString());
            e.printStackTrace();
        }
    }

    private void usage(String text) {
        this.log.plain(ME, "\nAvailable options:");
        this.log.plain(ME, "   -queryXpath         \"//key\"");
        System.out.println(Global.instance().usage());
        this.log.plain(ME, "Example: java javaclients.ClientQuery -queryXpath //key\n");
        this.log.plain(ME, text);
        System.exit(1);
    }

    public static void main(String[] args) {
        new ClientQuery(args);
    }
}

