/*
 * Decompiled with CFR 0.152.
 */
package javaclients;

import java.io.IOException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class ClientSub
implements I_Callback {
    private static String ME = "ClientSub";
    private final Global glob;
    private final LogChannel log;
    private int numReceived = 0;
    public static long startTime;
    public static long elapsed;

    public ClientSub(Global glob) {
        this.glob = glob;
        this.log = glob.getLog(null);
        try {
            I_XmlBlasterAccess blasterConnection = glob.getXmlBlasterAccess();
            blasterConnection.connect(null, this);
            int numTests = glob.getProperty().get("numTests", 1);
            int i = 0;
            while (i < numTests) {
                this.sendSomeMessages(blasterConnection);
                ++i;
            }
            blasterConnection.disconnect(null);
        }
        catch (Exception e) {
            this.log.error(ME, "Client failed: " + e.toString());
        }
    }

    private void sendSomeMessages(I_XmlBlasterAccess blasterConnection) {
        String subscriptionId = "";
        try {
            this.log.info(ME, "Subscribing using XPath syntax ...");
            SubscribeKey key = new SubscribeKey(this.glob, "/xmlBlaster/key/ClientSub-AGENT", "XPATH");
            SubscribeQos qos = new SubscribeQos(this.glob);
            try {
                subscriptionId = blasterConnection.subscribe(key.toXml(), qos.toXml()).getSubscriptionId();
                this.log.info(ME, "Subscribe done, there should be no Callback, subcriptionId=" + subscriptionId);
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if (this.numReceived == 0) {
                this.log.info(ME, "Success, no Callback for a simple subscribe without a publish");
            } else {
                this.log.error(ME, "Got Callback, but didn't expect one after a simple subscribe without a publish");
            }
            this.numReceived = 0;
            PublishReturnQos pubRetQos = null;
            String xmlKey = "<key oid='' contentMime='text/xml'>\n   <ClientSub-AGENT id='192.168.124.10' subId='1' type='generic'>      <ClientSub-DRIVER id='FileProof' pollingFreq='10'>      </ClientSub-DRIVER>   </ClientSub-AGENT></key>";
            String content = "Yeahh, i'm the new content";
            MsgUnit msgUnit = new MsgUnit(xmlKey, content.getBytes(), "<qos></qos>");
            this.log.info(ME, "Publishing ...");
            try {
                startTime = System.currentTimeMillis();
                pubRetQos = blasterConnection.publish(msgUnit);
                this.log.info(ME, "Publishing done, returned oid=" + pubRetQos.getKeyOid());
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "XmlBlasterException: " + e.getMessage());
                System.exit(1);
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if (this.numReceived == 1) {
                this.log.info(ME, "Success, got Callback after publishing");
            } else {
                this.log.error(ME, this.numReceived + " callbacks arrived, did expect one after a simple subscribe with a publish");
            }
            this.numReceived = 0;
            this.log.info(ME, "Hit a key to exit");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            xmlKey = "<key oid='" + subscriptionId + "'/>";
            String qos2 = "<qos></qos>";
            this.numReceived = 0;
            try {
                blasterConnection.unSubscribe(xmlKey, qos2);
                this.log.info(ME, "Success: UnSubscribe with " + subscriptionId + " done");
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            xmlKey = "<key oid='" + pubRetQos.getKeyOid() + "' queryType='EXACT'/>";
            try {
                EraseReturnQos[] strArr = blasterConnection.erase(xmlKey, "<qos></qos>");
                if (strArr.length != 1) {
                    this.log.error(ME, "Erased " + strArr.length + " messages:");
                }
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "XmlBlasterException: " + e.getMessage());
            }
        }
        catch (Exception e) {
            this.log.error(ME, "Client failed: " + e.toString());
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        elapsed = System.currentTimeMillis() - startTime;
        ++this.numReceived;
        this.log.info(ME, "Received asynchronous callback-update " + this.numReceived + " with cbSessionId='" + cbSessionId + "' from xmlBlaster from publisher " + updateQos.getSender() + " (latency=" + elapsed + " milli seconds):");
        this.log.plain("UpdateKey", updateKey.toXml());
        this.log.plain("content", new String(content).toString());
        this.log.plain("UpdateQos", updateQos.toXml());
        return "";
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            System.out.println("Get help: java javaclients.ClientSub -help\n");
            System.out.println("Example: java javaclients.ClientSub -session.name Jeff\n");
            System.exit(1);
        }
        new ClientSub(glob);
    }
}

