/*
 * Decompiled with CFR 0.152.
 */
package javaclients;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class ClientSubDispatch
implements I_Callback {
    private static String ME = "ClientSubDispatch";
    private final Global glob;
    private final LogChannel log;
    private int numReceived1 = 0;
    private int numReceived2 = 0;

    public ClientSubDispatch(Global glob) {
        this.glob = glob;
        this.log = glob.getLog(null);
        try {
            ConnectQos loginQos = new ConnectQos(null);
            I_XmlBlasterAccess blasterConnection = glob.getXmlBlasterAccess();
            blasterConnection.connect(loginQos, this);
            this.log.info(ME, "Subscribing #1 for anonymous callback class using XPath syntax ...");
            SubscribeKey key = new SubscribeKey(glob, "//DispatchTest", "XPATH");
            SubscribeQos qos = new SubscribeQos(glob);
            blasterConnection.subscribe(key, qos, new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    ClientSubDispatch.this.log.info(ME, "Receiving message with specialized update() #1 ...");
                    ClientSubDispatch.this.numReceived1++;
                    ClientSubDispatch.this.log.plain("UpdateKey", updateKey.toXml());
                    ClientSubDispatch.this.log.plain("content", new String(content).toString());
                    ClientSubDispatch.this.log.plain("UpdateQos", updateQos.toXml());
                    return "";
                }
            });
            this.log.info(ME, "Subscribing #2 for anonymous callback class using XPath syntax ...");
            key = new SubscribeKey(glob, "A message id");
            blasterConnection.subscribe(key, qos, new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    ClientSubDispatch.this.log.info(ME, "Receiving message with specialized update() #2 ...");
                    ClientSubDispatch.this.numReceived2++;
                    ClientSubDispatch.this.log.plain("UpdateKey", updateKey.toXml());
                    ClientSubDispatch.this.log.plain("content", new String(content).toString());
                    ClientSubDispatch.this.log.plain("UpdateQos", updateQos.toXml());
                    return "";
                }
            });
            String publishOid1 = "";
            String xmlKey = "<key oid='' contentMime='text/xml'>\n   <DispatchTest>   </DispatchTest></key>";
            String content = "Some content #1";
            MsgUnit msgUnit = new MsgUnit(xmlKey, content.getBytes(), "<qos></qos>");
            publishOid1 = blasterConnection.publish(msgUnit).getKeyOid();
            this.log.info(ME, "Publishing done, returned oid=" + publishOid1);
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            String publishOid2 = "";
            xmlKey = "<key oid='A message id' contentMime='text/xml'>\n</key>";
            content = "Some content #2";
            msgUnit = new MsgUnit(xmlKey, content.getBytes(), "<qos></qos>");
            publishOid2 = blasterConnection.publish(msgUnit).getKeyOid();
            this.log.info(ME, "Publishing done, returned oid=" + publishOid2);
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if (this.numReceived1 == 1) {
                this.log.info(ME, "Success, got Callback #1 after publishing");
            } else {
                this.log.error(ME, this.numReceived1 + " callbacks arrived, did expect one after a simple subscribe with a publish");
            }
            if (this.numReceived2 == 1) {
                this.log.info(ME, "Success, got Callback #2 after publishing");
            } else {
                this.log.error(ME, this.numReceived2 + " callbacks arrived, did expect one after a simple subscribe with a publish");
            }
            xmlKey = "<key oid='" + publishOid1 + "' queryType='EXACT'>\n" + "</key>";
            EraseReturnQos[] strArr = blasterConnection.erase(xmlKey, "<qos></qos>");
            if (strArr.length != 1) {
                this.log.error(ME, "Erased " + strArr.length + " message.");
            }
            if ((strArr = blasterConnection.erase(xmlKey = "<key oid='" + publishOid2 + "' queryType='EXACT'>\n" + "</key>", "<qos></qos>")).length != 1) {
                this.log.error(ME, "Erased " + strArr.length + " message.");
            }
            blasterConnection.disconnect(null);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error(ME, "Client failed: " + e.toString());
            e.printStackTrace();
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.error(ME, "Received unexpected asynchronous callback-update from xmlBlaster from publisher " + updateQos.getSender() + ":");
        this.log.error(ME, updateKey.toXml() + "\n" + updateQos.toXml());
        return "";
    }

    public static void main(String[] args) {
        new ClientSubDispatch(new Global(args));
    }
}

