/*
 * Decompiled with CFR 0.152.
 */
package javaclients;

import org.jutils.init.Args;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class ClientSubEmail
implements I_Callback {
    private static String ME = "ClientSubEmail";
    private int numReceived = 0;
    private final LogChannel log;

    public ClientSubEmail(String[] args) {
        Global glob = this.initArgs(args);
        this.log = glob.getLog(null);
        try {
            String loginName = Args.getArg(args, "-loginName", ME);
            String passwd = Args.getArg(args, "-passwd", "secret");
            ConnectQos loginQos = new ConnectQos(glob, loginName, passwd);
            CallbackAddress c = new CallbackAddress(glob, "EMAIL");
            c.setRawAddress(Args.getArg(args, "-email", "et@xyz.org"));
            loginQos.addCallbackAddress(c);
            c = new CallbackAddress(glob, "EMAIL");
            c.setRawAddress(Args.getArg(args, "-email2", "root@localhost"));
            loginQos.addCallbackAddress(c);
            c = new CallbackAddress(glob, "EMAIL");
            c.setRawAddress(Args.getArg(args, "-email3", "et@xyz.org"));
            loginQos.addCallbackAddress(c);
            I_XmlBlasterAccess blasterConnection = glob.getXmlBlasterAccess();
            blasterConnection.connect(loginQos, this);
            this.log.info(ME, "Subscribing using XPath syntax ...");
            SubscribeKey key = new SubscribeKey(glob, "/xmlBlaster/key/DemoMail", "XPATH");
            SubscribeQos qos = new SubscribeQos(glob);
            try {
                blasterConnection.subscribe(key.toXml(), qos.toXml());
                this.log.info(ME, "Subscribe done, there should be no Callback");
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if (this.numReceived == 0) {
                this.log.info(ME, "Success, no Callback for a simple subscribe without a publish");
            } else {
                this.log.error(ME, "Got Callback, but didn't expect one after a simple subscribe without a publish");
            }
            this.numReceived = 0;
            String publishOid = "";
            String xmlKey = "<key oid='EDDI.RWY1.mail' contentMime='text/plain'>\n   <DemoMail>\n   </DemoMail>\n</key>";
            String content = Args.getArg(args, "-email.content", "Hello world");
            MsgUnit msgUnit = new MsgUnit(xmlKey, content.getBytes(), "<qos></qos>");
            this.log.info(ME, "Publishing ...");
            try {
                publishOid = blasterConnection.publish(msgUnit).getKeyOid();
                this.log.info(ME, "Publishing done, returned oid=" + publishOid);
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if (this.numReceived == 1) {
                this.log.info(ME, "Success, got Callback after publishing");
            } else {
                this.log.error(ME, this.numReceived + " callbacks arrived, did expect one after a simple subscribe with a publish");
            }
            this.numReceived = 0;
            xmlKey = "<key oid='" + publishOid + "' queryType='EXACT'>\n" + "</key>";
            try {
                EraseReturnQos[] arr = blasterConnection.erase(xmlKey, "<qos></qos>");
                if (arr.length != 1) {
                    this.log.error(ME, "Erased " + arr.length + " messages:");
                }
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "XmlBlasterException: " + e.getMessage());
            }
            blasterConnection.disconnect(null);
        }
        catch (Exception e) {
            this.log.error(ME, "Client failed: " + e.toString());
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        ++this.numReceived;
        this.log.info(ME, "Received asynchronous callback-update " + this.numReceived + " from xmlBlaster from publisher " + updateQos.getSender() + ":");
        this.log.plain("UpdateKey", updateKey.toXml());
        this.log.plain("content", new String(content).toString());
        this.log.plain("UpdateQos", updateQos.toXml());
        return "";
    }

    private Global initArgs(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            this.log.plain(ME, "\nAvailable options:");
            this.log.plain(ME, "   -loginName          The login name [ClientSubEmail].");
            this.log.plain(ME, "   -passwd             The login name [secret].");
            this.log.plain(ME, "   -email              An email address to send updates [xmlBlaster@marcelruff.info].");
            this.log.plain(ME, "   -email.content      The content of the email [Hello world].");
            this.log.plain(ME, "NOTE:");
            this.log.plain(ME, "   Activate the email callback plugin in xmlBlaster.properies first, for example:");
            this.log.plain(ME, "   CbProtocolPlugin[EMAIL][1.0]=org.xmlBlaster.protocol.email.CallbackEmailDriver");
            this.log.plain(ME, "   EmailDriver.smtpHost=localhost");
            this.log.plain(ME, "   EmailDriver.from=xmlblast@localhost");
            System.out.println(glob.usage());
            this.log.info(ME, "Example: java javaclients.ClientSubEmail -loginName Jeff -email et@universe.xy\n");
            System.exit(1);
        }
        return glob;
    }

    public static void main(String[] args) {
        new ClientSubEmail(args);
    }
}

