/*
 * Decompiled with CFR 0.152.
 */
package javaclients;

import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class ClientXml
implements I_Callback {
    private static String ME = "ClientXml";
    private final LogChannel log;

    public ClientXml(String[] args) {
        Global glob = new Global();
        this.log = glob.getLog(null);
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            this.log.info(ME, "Example: java javaclients.ClientXml -loginName Jeff\n");
            System.exit(1);
        }
        StopWatch stop = new StopWatch();
        try {
            I_XmlBlasterAccess blasterConnection = glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(glob);
            blasterConnection.connect(qos, this);
            String publishOid = "";
            String xmlKey = "<key oid='' contentMime='text/xml'>\n<AGENT id='192.168.124.10' subId='1' type='generic'><DRIVER id='FileProof' pollingFreq='10'></DRIVER></AGENT></key>";
            String content = "<person><name>Ghandi</name></person>";
            MsgUnit msgUnit = new MsgUnit(xmlKey, content.getBytes(), "");
            this.log.trace(ME, "Publishing ...");
            stop.restart();
            try {
                publishOid = blasterConnection.publish(msgUnit).getKeyOid();
                this.log.info(ME, "   Returned oid=" + publishOid);
                this.log.trace(ME, "Publishing done" + stop.nice());
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "Punlishing failed, XmlBlasterException: " + e.getMessage());
            }
            this.log.trace(ME, "Subscribing using the exact oid ...");
            xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='" + publishOid + "' queryType='EXACT'>\n" + "</key>";
            stop.restart();
            try {
                String subId = blasterConnection.subscribe(xmlKey, "<qos></qos>").getSubscriptionId();
                this.log.trace(ME, "Subscribed to '" + subId + "' ..." + stop.nice());
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "Subscribe failed, XmlBlasterException: " + e.getMessage());
            }
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            this.log.trace(ME, "Unsubscribe ...");
            stop.restart();
            try {
                blasterConnection.unSubscribe(xmlKey, "<qos></qos>");
                this.log.info(ME, "Unsubscribe done" + stop.nice());
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "Unsubscribe failed, XmlBlasterException: " + e.getMessage());
            }
            this.log.trace(ME, "Subscribing using XPath syntax ...");
            xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='' queryType='XPATH'>\n/xmlBlaster/key/AGENT</key>";
            stop.restart();
            try {
                blasterConnection.subscribe(xmlKey, "<qos></qos>");
                this.log.trace(ME, "Subscribe done, there should be a Callback");
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "subscribe failed, XmlBlasterException: " + e.getMessage());
            }
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            this.log.trace(ME, "Publishing 10 times ...");
            int ii = 0;
            while (ii < 10) {
                String content2 = "<person><name>Castro</name><age>" + ii + "</age></person>";
                xmlKey = "<key oid='" + publishOid + "' contentMime='text/xml'>\n</key>";
                MsgUnit msgUnit2 = new MsgUnit(xmlKey, content2.getBytes(), "");
                this.log.trace(ME, "Publishing ...");
                stop.restart();
                try {
                    String str = blasterConnection.publish(msgUnit2).getKeyOid();
                    this.log.trace(ME, "Publishing done" + stop.nice());
                }
                catch (XmlBlasterException e) {
                    this.log.error(ME, "Publishing failed, XmlBlasterException: " + e.getMessage());
                }
                ++ii;
            }
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            blasterConnection.disconnect(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of message [" + updateKey.getOid() + "]");
        return "";
    }

    public static void main(String[] args) {
        new ClientXml(args);
    }
}

