/*
 * Decompiled with CFR 0.152.
 */
package javaclients;

import java.io.IOException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class HelloWorldErase {
    private final String ME = "HelloWorldErase";
    private final Global glob;
    private final LogChannel log;

    public HelloWorldErase(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("HelloWorldErase");
        try {
            boolean interactive = glob.getProperty().get("interactive", true);
            String oid = glob.getProperty().get("oid", "Hello");
            String xpath = glob.getProperty().get("xpath", (String)null);
            boolean forceDestroy = glob.getProperty().get("forceDestroy", false);
            boolean persistent = glob.getProperty().get("persistent", false);
            this.log.info("HelloWorldErase", "Used settings are:");
            this.log.info("HelloWorldErase", "   -interactive    " + interactive);
            this.log.info("HelloWorldErase", "   -oid            " + oid);
            this.log.info("HelloWorldErase", "   -xpath          " + xpath);
            this.log.info("HelloWorldErase", "   -forceDestroy   " + forceDestroy);
            this.log.info("HelloWorldErase", "   -persistent     " + persistent);
            I_XmlBlasterAccess con = glob.getXmlBlasterAccess();
            this.log.info("HelloWorldErase", "============= CreatingConnectQos");
            ConnectQos qos = new ConnectQos(glob);
            this.log.info("HelloWorldErase", "ConnectQos is " + qos.toXml());
            ConnectReturnQos crq = con.connect(qos, null);
            this.log.info("HelloWorldErase", "Connect success as " + crq.toXml());
            if (interactive) {
                this.log.info("HelloWorldErase", "Hit a key to erase");
                try {
                    System.in.read();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            EraseKey ek = xpath != null ? new EraseKey(glob, xpath, "XPATH") : new EraseKey(glob, oid);
            EraseQos eq = new EraseQos(glob);
            eq.setForceDestroy(forceDestroy);
            eq.setPersistent(persistent);
            EraseReturnQos[] eraseArr = con.erase(ek, eq);
            int i = 0;
            while (i < eraseArr.length) {
                this.log.info("HelloWorldErase", eraseArr[i].toXml());
                ++i;
            }
            this.log.info("HelloWorldErase", "Erased " + eraseArr.length + " topics");
            this.log.info("HelloWorldErase", "Hit a key to exit");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            DisconnectQos dq = new DisconnectQos(glob);
            con.disconnect(dq);
        }
        catch (XmlBlasterException e) {
            this.log.error("HelloWorldErase", e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("HelloWorldErase", e.toString());
        }
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            System.err.println("\nExample:");
            System.err.println("  java javaclients.HelloWorldErase -oid hello\n");
            System.exit(1);
        }
        new HelloWorldErase(glob);
    }
}

