/*
 * Decompiled with CFR 0.152.
 */
package javaclients;

import java.io.IOException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.GetReturnKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.GetReturnQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.AccessFilterQos;
import org.xmlBlaster.util.qos.HistoryQos;

public class HelloWorldGet {
    private final String ME = "HelloWorldGet";
    private final Global glob;
    private final LogChannel log;
    private int updateCounter = 0;

    public HelloWorldGet(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("HelloWorldGet");
        try {
            boolean interactive = glob.getProperty().get("interactive", true);
            String oid = glob.getProperty().get("oid", "");
            String xpath = glob.getProperty().get("xpath", "");
            int numHistory = glob.getProperty().get("numHistory", 1);
            String filterType = glob.getProperty().get("filter.type", "GnuRegexFilter");
            String filterVersion = glob.getProperty().get("filter.version", "1.0");
            String filterQuery = glob.getProperty().get("filter.query", "");
            boolean content = glob.getProperty().get("content", true);
            boolean disconnect = glob.getProperty().get("disconnect", true);
            if (oid.length() < 1 && xpath.length() < 1) {
                this.log.warn("HelloWorldGet", "No -oid or -xpath given, we subscribe to oid='Hello'.");
                oid = "Hello";
            }
            this.log.info("HelloWorldGet", "Used settings are:");
            this.log.info("HelloWorldGet", "   -interactive       " + interactive);
            this.log.info("HelloWorldGet", "   -oid               " + oid);
            this.log.info("HelloWorldGet", "   -xpath             " + xpath);
            this.log.info("HelloWorldGet", "   -numHistory        " + numHistory);
            this.log.info("HelloWorldGet", "   -content           " + content);
            this.log.info("HelloWorldGet", "   -disconnect        " + disconnect);
            this.log.info("HelloWorldGet", "   -filter.type       " + filterType);
            this.log.info("HelloWorldGet", "   -filter.version    " + filterVersion);
            this.log.info("HelloWorldGet", "   -filter.query      " + filterQuery);
            this.log.info("HelloWorldGet", "For more info please read:");
            this.log.info("HelloWorldGet", "   http://www.xmlBlaster.org/xmlBlaster/doc/requirements/interface.get.html");
            I_XmlBlasterAccess con = glob.getXmlBlasterAccess();
            this.log.info("HelloWorldGet", "============= CreatingConnectQos");
            ConnectQos qos = new ConnectQos(glob);
            this.log.info("HelloWorldGet", "ConnectQos is " + qos.toXml());
            ConnectReturnQos crq = con.connect(qos, null);
            this.log.info("HelloWorldGet", "Connect success as " + crq.toXml());
            GetKey gk = oid.length() > 0 ? new GetKey(glob, oid) : new GetKey(glob, xpath, "XPATH");
            GetQos gq = new GetQos(glob);
            gq.setWantContent(content);
            HistoryQos historyQos = new HistoryQos(glob);
            historyQos.setNumEntries(numHistory);
            gq.setHistoryQos(historyQos);
            if (filterQuery.length() > 0) {
                AccessFilterQos filter = new AccessFilterQos(glob, filterType, filterVersion, filterQuery);
                gq.addAccessFilter(filter);
            }
            this.log.info("HelloWorldGet", "GetKey=\n" + gk.toXml());
            this.log.info("HelloWorldGet", "GetQos=\n" + gq.toXml());
            if (interactive) {
                this.log.info("HelloWorldGet", "Hit a key to get '" + (oid.length() > 0 ? oid : xpath) + "'");
                try {
                    System.in.read();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            MsgUnit[] msgs = con.get(gk.toXml(), gq.toXml());
            int imsg = 0;
            while (imsg < msgs.length) {
                GetReturnKey grk = new GetReturnKey(glob, msgs[imsg].getKey());
                GetReturnQos grq = new GetReturnQos(glob, msgs[imsg].getQos());
                String contentStr = msgs[imsg].getContentStr();
                System.out.println("");
                System.out.println("============= START #" + (imsg + 1) + " '" + grk.getOid() + "' =======================");
                this.log.info("HelloWorldGet", "Receiving update #" + (imsg + 1) + " of a message ...");
                System.out.println("<xmlBlaster>");
                System.out.println(msgs[imsg].toXml("", 100));
                System.out.println("</xmlBlaster>");
                System.out.println("============= END #" + (imsg + 1) + " '" + grk.getOid() + "' =========================");
                System.out.println("");
                ++imsg;
            }
            if (msgs.length == 0) {
                this.log.info("HelloWorldGet", "Sorry, no message found for '" + (oid.length() > 0 ? oid : xpath) + "'");
            }
            this.log.info("HelloWorldGet", "Hit a key to exit");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (disconnect) {
                DisconnectQos dq = new DisconnectQos(glob);
                con.disconnect(dq);
            }
        }
        catch (XmlBlasterException e) {
            this.log.error("HelloWorldGet", e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("HelloWorldGet", e.toString());
        }
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            System.err.println("\nExample:");
            System.err.println("  java javaclients.HelloWorldGet -oid Hello -initialUpdate true\n");
            System.exit(1);
        }
        new HelloWorldGet(glob);
    }
}

