/*
 * Decompiled with CFR 0.152.
 */
package javaclients;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.qos.AccessFilterQos;

public class HelloWorldMime
implements I_Callback {
    private final LogChannel log;

    public HelloWorldMime(Global glob) {
        this.log = glob.getLog(null);
        try {
            I_XmlBlasterAccess con = glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(glob);
            con.connect(qos, this);
            PublishKey pk = new PublishKey(glob, "HelloWorldMime", "text/xml");
            pk.setClientTags("<org.xmlBlaster><demo/></org.xmlBlaster>");
            PublishQos pq = new PublishQos(glob);
            MsgUnit msgUnit = new MsgUnit(pk, "<news type='sport'/>".getBytes(), pq);
            con.publish(msgUnit);
            GetKey gk = new GetKey(glob, "HelloWorldMime");
            GetQos gq = new GetQos(glob);
            gq.addAccessFilter(new AccessFilterQos(glob, "XPathFilter", "1.0", "/news[@type='sport']"));
            MsgUnit[] msgs = con.get(gk, gq);
            this.log.info("", "Accessed xmlBlaster message synchronous with get() with content '" + new String(msgs[0].getContent()) + "'");
            SubscribeKey sk = new SubscribeKey(glob, "HelloWorldMime");
            SubscribeQos sq = new SubscribeQos(glob);
            sq.addAccessFilter(new AccessFilterQos(glob, "XPathFilter", "1.0", "/news[@type='fishing']"));
            SubscribeReturnQos subRet = con.subscribe(sk, sq);
            msgUnit = new MsgUnit(pk, "<news type='fishing'/>".getBytes(), pq);
            con.publish(msgUnit);
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            UnSubscribeKey uk = new UnSubscribeKey(glob, subRet.getSubscriptionId());
            UnSubscribeQos uq = new UnSubscribeQos(glob);
            con.unSubscribe(uk, uq);
            EraseKey ek = new EraseKey(glob, "HelloWorldMime");
            EraseQos eq = new EraseQos(glob);
            EraseReturnQos[] eraseArr = con.erase(ek, eq);
            DisconnectQos dq = new DisconnectQos(glob);
            con.disconnect(dq);
        }
        catch (Exception e) {
            this.log.error("", e.getMessage());
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        if (updateKey.isInternal()) {
            this.log.info("", "Received unexpected internal message '" + updateKey.getOid() + " from xmlBlaster");
            return "";
        }
        this.log.info("", "Received asynchronous message '" + updateKey.getOid() + "' state=" + updateQos.getState() + " content=" + new String(content) + " from xmlBlaster");
        return "";
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            System.err.println("Example: java javaclients.HelloWorldMime -session.name Jeff\n");
            System.exit(1);
        }
        new HelloWorldMime(glob);
    }
}

