/*
 * Decompiled with CFR 0.152.
 */
package javaclients;

import java.util.Iterator;
import java.util.Map;
import org.jutils.log.LogChannel;
import org.jutils.text.StringHelper;
import org.jutils.time.StopWatch;
import org.jutils.time.TimeHelper;
import org.xmlBlaster.client.I_ConnectionStateListener;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.qos.TopicProperty;
import org.xmlBlaster.util.qos.address.Destination;
import org.xmlBlaster.util.qos.storage.HistoryQueueProperty;

public class HelloWorldPublish {
    private final String ME = "HelloWorldPublish";
    private final Global glob;
    private final LogChannel log;

    public HelloWorldPublish(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("HelloWorldPublish");
        try {
            boolean interactive = glob.getProperty().get("interactive", true);
            boolean oneway = glob.getProperty().get("oneway", false);
            long sleep = glob.getProperty().get("sleep", 1000L);
            int numPublish = glob.getProperty().get("numPublish", 1);
            String oid = glob.getProperty().get("oid", "Hello");
            String clientTags = glob.getProperty().get("clientTags", "<org.xmlBlaster><demo-%counter/></org.xmlBlaster>");
            String contentStr = glob.getProperty().get("content", "Hi-%counter");
            PriorityEnum priority = PriorityEnum.toPriorityEnum(glob.getProperty().get("priority", PriorityEnum.NORM_PRIORITY.getInt()));
            boolean persistent = glob.getProperty().get("persistent", true);
            long lifeTime = glob.getProperty().get("lifeTime", -1L);
            boolean forceUpdate = glob.getProperty().get("forceUpdate", true);
            boolean forceDestroy = glob.getProperty().get("forceDestroy", false);
            boolean readonly = glob.getProperty().get("readonly", false);
            long destroyDelay = glob.getProperty().get("destroyDelay", 60000L);
            boolean createDomEntry = glob.getProperty().get("createDomEntry", true);
            long historyMaxMsg = glob.getProperty().get("queue/history/maxEntries", -1L);
            boolean forceQueuing = glob.getProperty().get("forceQueuing", true);
            boolean subscribable = glob.getProperty().get("subscribable", true);
            String destination = glob.getProperty().get("destination", (String)null);
            boolean erase = glob.getProperty().get("erase", true);
            boolean disconnect = glob.getProperty().get("disconnect", true);
            final boolean eraseTailback = glob.getProperty().get("eraseTailback", false);
            int contentSize = glob.getProperty().get("contentSize", -1);
            boolean eraseForceDestroy = glob.getProperty().get("erase.forceDestroy", false);
            Map clientPropertyMap = glob.getProperty().get("clientProperty", (Map)null);
            if (historyMaxMsg < 1L && !glob.getProperty().propertyExists("destroyDelay")) {
                destroyDelay = 86400000L;
            }
            this.log.info("HelloWorldPublish", "Used settings are:");
            this.log.info("HelloWorldPublish", "   -interactive    " + interactive);
            this.log.info("HelloWorldPublish", "   -sleep          " + TimeHelper.millisToNice(sleep));
            this.log.info("HelloWorldPublish", "   -oneway         " + oneway);
            this.log.info("HelloWorldPublish", "   -erase          " + erase);
            this.log.info("HelloWorldPublish", "   -disconnect     " + disconnect);
            this.log.info("HelloWorldPublish", "   -eraseTailback  " + eraseTailback);
            this.log.info("HelloWorldPublish", " Pub/Sub settings");
            this.log.info("HelloWorldPublish", "   -numPublish     " + numPublish);
            this.log.info("HelloWorldPublish", "   -oid            " + oid);
            this.log.info("HelloWorldPublish", "   -clientTags     " + clientTags);
            if (contentSize >= 0) {
                this.log.info("HelloWorldPublish", "   -content        [generated]");
                this.log.info("HelloWorldPublish", "   -contentSize    " + contentSize);
            } else {
                this.log.info("HelloWorldPublish", "   -content        " + contentStr);
                this.log.info("HelloWorldPublish", "   -contentSize    " + contentStr.length());
            }
            this.log.info("HelloWorldPublish", "   -priority       " + priority.toString());
            this.log.info("HelloWorldPublish", "   -persistent     " + persistent);
            this.log.info("HelloWorldPublish", "   -lifeTime       " + TimeHelper.millisToNice(lifeTime));
            this.log.info("HelloWorldPublish", "   -forceUpdate    " + forceUpdate);
            this.log.info("HelloWorldPublish", "   -forceDestroy   " + forceDestroy);
            if (clientPropertyMap != null) {
                Iterator it = clientPropertyMap.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    this.log.info("HelloWorldPublish", "   -clientProperty[" + key + "]   " + clientPropertyMap.get(key).toString());
                }
            } else {
                this.log.info("HelloWorldPublish", "   -clientProperty[]   ");
            }
            this.log.info("HelloWorldPublish", " Topic settings");
            this.log.info("HelloWorldPublish", "   -readonly       " + readonly);
            this.log.info("HelloWorldPublish", "   -destroyDelay   " + TimeHelper.millisToNice(destroyDelay));
            this.log.info("HelloWorldPublish", "   -createDomEntry " + createDomEntry);
            this.log.info("HelloWorldPublish", "   -queue/history/maxEntries " + historyMaxMsg);
            this.log.info("HelloWorldPublish", " PtP settings");
            this.log.info("HelloWorldPublish", "   -subscribable  " + subscribable);
            this.log.info("HelloWorldPublish", "   -forceQueuing   " + forceQueuing);
            this.log.info("HelloWorldPublish", "   -destination    " + destination);
            this.log.info("HelloWorldPublish", " Erase settings");
            this.log.info("HelloWorldPublish", "   -erase.forceDestroy " + eraseForceDestroy);
            this.log.info("HelloWorldPublish", "For more info please read:");
            this.log.info("HelloWorldPublish", "   http://www.xmlBlaster.org/xmlBlaster/doc/requirements/interface.publish.html");
            I_XmlBlasterAccess con = glob.getXmlBlasterAccess();
            con.registerConnectionListener(new I_ConnectionStateListener(){

                public void reachedAlive(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
                    if (eraseTailback) {
                        HelloWorldPublish.this.log.info("HelloWorldPublish", "Destroying " + connection.getQueue().getNumOfEntries() + " client side tailback messages");
                        connection.getQueue().clear();
                    }
                }

                public void reachedPolling(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
                    HelloWorldPublish.this.log.warn("HelloWorldPublish", "I_ConnectionStateListener: No connection to xmlBlaster server, we are polling ...");
                }

                public void reachedDead(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
                    HelloWorldPublish.this.log.warn("HelloWorldPublish", "I_ConnectionStateListener: Connection from " + connection.getGlobal().getId() + " to xmlBlaster is DEAD, doing exit.");
                    System.exit(1);
                }
            });
            this.log.info("HelloWorldPublish", "============= CreatingConnectQos");
            ConnectQos qos = new ConnectQos(glob);
            this.log.info("HelloWorldPublish", "ConnectQos is " + qos.toXml());
            ConnectReturnQos crq = con.connect(qos, null);
            this.log.info("HelloWorldPublish", "Connect success as " + crq.toXml());
            StopWatch stopWatch = new StopWatch();
            int i = 0;
            while (i < numPublish) {
                byte[] content;
                if (interactive) {
                    Global.waitOnKeyboardHit("Hit a key to publish '" + oid + "' #" + (i + 1) + "/" + numPublish);
                } else {
                    if (sleep > 0L) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    this.log.info("HelloWorldPublish", "Publish '" + oid + "' #" + (i + 1) + "/" + numPublish);
                }
                PublishKey pk = new PublishKey(glob, oid, "text/xml", "1.0");
                pk.setClientTags(StringHelper.replaceAll(clientTags, "%counter", "" + (i + 1)));
                PublishQos pq = new PublishQos(glob);
                pq.setPriority(priority);
                pq.setPersistent(persistent);
                pq.setLifeTime(lifeTime);
                pq.setForceUpdate(forceUpdate);
                pq.setForceDestroy(forceDestroy);
                pq.setSubscribable(subscribable);
                if (clientPropertyMap != null) {
                    Iterator it = clientPropertyMap.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        pq.addClientProperty(key, clientPropertyMap.get(key).toString());
                    }
                }
                if (i == 0) {
                    TopicProperty topicProperty = new TopicProperty(glob);
                    topicProperty.setDestroyDelay(destroyDelay);
                    topicProperty.setCreateDomEntry(createDomEntry);
                    topicProperty.setReadonly(readonly);
                    if (historyMaxMsg >= 0L) {
                        HistoryQueueProperty prop = new HistoryQueueProperty(this.glob, null);
                        prop.setMaxEntries(historyMaxMsg);
                        topicProperty.setHistoryQueueProperty(prop);
                    }
                    pq.setTopicProperty(topicProperty);
                    this.log.info("HelloWorldPublish", "Added TopicProperty on first publish: " + topicProperty.toXml());
                }
                if (destination != null) {
                    Destination dest = new Destination(glob, new SessionName(glob, destination));
                    dest.forceQueuing(forceQueuing);
                    pq.addDestination(dest);
                }
                if (contentSize >= 0) {
                    content = new byte[contentSize];
                    int j = 0;
                    while (j < content.length) {
                        content[j] = 88;
                        ++j;
                    }
                } else {
                    content = StringHelper.replaceAll(contentStr, "%counter", "" + (i + 1)).getBytes();
                }
                MsgUnit msgUnit = new MsgUnit(pk, content, pq);
                if (this.log.DUMP) {
                    this.log.dump("", "Going to publish message: " + msgUnit.toXml());
                }
                if (oneway) {
                    MsgUnit[] msgUnitArr = new MsgUnit[]{msgUnit};
                    con.publishOneway(msgUnitArr);
                    this.log.info("HelloWorldPublish", "#" + (i + 1) + "/" + numPublish + ": Published oneway message '" + msgUnit.getKeyOid() + "'");
                } else {
                    PublishReturnQos prq = con.publish(msgUnit);
                    if (this.log.DUMP) {
                        this.log.dump("", "Returned: " + prq.toXml());
                    }
                    this.log.info("HelloWorldPublish", "#" + (i + 1) + "/" + numPublish + ": Got status='" + prq.getState() + "' rcvTimestamp=" + prq.getRcvTimestamp() + " for published message '" + prq.getKeyOid() + "'");
                }
                ++i;
            }
            this.log.info("HelloWorldPublish", "Elapsed since starting to publish: " + stopWatch.nice(numPublish));
            if (erase) {
                if (interactive) {
                    Global.waitOnKeyboardHit("Hit a key to erase");
                }
                EraseKey ek = new EraseKey(glob, oid);
                EraseQos eq = new EraseQos(glob);
                eq.setForceDestroy(eraseForceDestroy);
                if (this.log.DUMP) {
                    this.log.dump("", "Going to erase the topic: " + ek.toXml() + eq.toXml());
                }
                EraseReturnQos[] eraseArr = con.erase(ek, eq);
                this.log.info("HelloWorldPublish", "Erase success");
            }
            Global.waitOnKeyboardHit("Hit a key to exit");
            if (disconnect) {
                DisconnectQos dq = new DisconnectQos(glob);
                con.disconnect(dq);
            }
        }
        catch (XmlBlasterException e) {
            this.log.error("HelloWorldPublish", e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("HelloWorldPublish", e.toString());
        }
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            System.err.println("\nExample:");
            System.err.println("  java javaclients.HelloWorldPublish -interactive false -sleep 1000 -numPublish 10 -oid Hello -persistent true -erase true\n");
            System.err.println("  java javaclients.HelloWorldPublish  -clientProperty[myString] Hello -clientProperty[correlationId] 100\n");
            System.exit(1);
        }
        new HelloWorldPublish(glob);
    }
}

