/*
 * Decompiled with CFR 0.152.
 */
package javaclients;

import java.util.Iterator;
import java.util.Map;
import org.jutils.JUtilsException;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.qos.AccessFilterQos;
import org.xmlBlaster.util.qos.ClientProperty;
import org.xmlBlaster.util.qos.HistoryQos;

public class HelloWorldSubscribe
implements I_Callback {
    private final String ME = "HelloWorldSubscribe";
    private final Global glob;
    private final LogChannel log;
    private int updateCounter;
    private boolean interactiveUpdate;
    private long updateSleep;
    private String updateExceptionErrorCode;
    private String updateExceptionMessage;
    private String updateExceptionRuntime;
    private int maxContentLength;
    boolean dumpContent;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HelloWorldSubscribe(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("HelloWorldSubscribe");
        I_XmlBlasterAccess con = null;
        boolean disconnect = glob.getProperty().get("disconnect", true);
        try {
            try {
                boolean persistentConnection = glob.getProperty().get("persistentConnection", false);
                boolean interactive = glob.getProperty().get("interactive", true);
                this.interactiveUpdate = glob.getProperty().get("interactiveUpdate", false);
                this.updateSleep = glob.getProperty().get("updateSleep", 0L);
                this.updateExceptionErrorCode = glob.getProperty().get("updateException.errorCode", (String)null);
                this.updateExceptionMessage = glob.getProperty().get("updateException.message", (String)null);
                this.updateExceptionRuntime = glob.getProperty().get("updateException.runtime", (String)null);
                boolean shutdownCbServer = glob.getProperty().get("shutdownCbServer", false);
                String oid = glob.getProperty().get("oid", "");
                String domain = glob.getProperty().get("domain", "");
                String xpath = glob.getProperty().get("xpath", "");
                boolean multiSubscribe = glob.getProperty().get("multiSubscribe", true);
                boolean persistentSubscribe = glob.getProperty().get("persistentSubscribe", false);
                boolean notifyOnErase = glob.getProperty().get("notifyOnErase", true);
                boolean local = glob.getProperty().get("local", true);
                boolean initialUpdate = glob.getProperty().get("initialUpdate", true);
                boolean wantContent = glob.getProperty().get("wantContent", true);
                this.dumpContent = glob.getProperty().get("dumpContent", false);
                int historyNumUpdates = glob.getProperty().get("historyNumUpdates", 1);
                boolean historyNewestFirst = glob.getProperty().get("historyNewestFirst", true);
                String filterType = glob.getProperty().get("filter.type", "GnuRegexFilter");
                String filterVersion = glob.getProperty().get("filter.version", "1.0");
                String filterQuery = glob.getProperty().get("filter.query", "");
                boolean unSubscribe = glob.getProperty().get("unSubscribe", true);
                this.maxContentLength = glob.getProperty().get("maxContentLength", 250);
                if (oid.length() < 1 && xpath.length() < 1) {
                    this.log.warn("HelloWorldSubscribe", "No -oid or -xpath given, we subscribe to oid='Hello'.");
                    oid = "Hello";
                }
                if (this.updateSleep > 0L && this.interactiveUpdate) {
                    this.log.warn("HelloWorldSubscribe", "You can't set 'updateSleep' and  'interactiveUpdate' simultaneous, we reset interactiveUpdate to false");
                    this.interactiveUpdate = false;
                }
                if (this.updateExceptionErrorCode != null && this.updateExceptionRuntime != null) {
                    this.log.warn("HelloWorldSubscribe", "You can't throw a runtime and an XmlBlasterException simultaneous, please check your settings  -updateException.errorCode and -updateException.runtime");
                    this.updateExceptionRuntime = null;
                }
                this.log.info("HelloWorldSubscribe", "Used settings are:");
                this.log.info("HelloWorldSubscribe", "   -persistentConnection " + persistentConnection);
                this.log.info("HelloWorldSubscribe", "   -interactive       " + interactive);
                this.log.info("HelloWorldSubscribe", "   -interactiveUpdate " + this.interactiveUpdate);
                this.log.info("HelloWorldSubscribe", "   -updateSleep       " + this.updateSleep);
                this.log.info("HelloWorldSubscribe", "   -updateException.errorCode " + this.updateExceptionErrorCode);
                this.log.info("HelloWorldSubscribe", "   -updateException.message   " + this.updateExceptionMessage);
                this.log.info("HelloWorldSubscribe", "   -updateException.runtime   " + this.updateExceptionRuntime);
                this.log.info("HelloWorldSubscribe", "   -shutdownCbServer          " + shutdownCbServer);
                this.log.info("HelloWorldSubscribe", "   -oid               " + oid);
                this.log.info("HelloWorldSubscribe", "   -domain            " + domain);
                this.log.info("HelloWorldSubscribe", "   -xpath             " + xpath);
                this.log.info("HelloWorldSubscribe", "   -multiSubscribe    " + multiSubscribe);
                this.log.info("HelloWorldSubscribe", "   -persistentSubscribe " + persistentSubscribe);
                this.log.info("HelloWorldSubscribe", "   -notifyOnErase     " + notifyOnErase);
                this.log.info("HelloWorldSubscribe", "   -local             " + local);
                this.log.info("HelloWorldSubscribe", "   -initialUpdate     " + initialUpdate);
                this.log.info("HelloWorldSubscribe", "   -historyNumUpdates " + historyNumUpdates);
                this.log.info("HelloWorldSubscribe", "   -historyNewestFirst " + historyNewestFirst);
                this.log.info("HelloWorldSubscribe", "   -wantContent       " + wantContent);
                this.log.info("HelloWorldSubscribe", "   -dumpContent       " + this.dumpContent);
                this.log.info("HelloWorldSubscribe", "   -unSubscribe       " + unSubscribe);
                this.log.info("HelloWorldSubscribe", "   -disconnect        " + disconnect);
                this.log.info("HelloWorldSubscribe", "   -filter.type       " + filterType);
                this.log.info("HelloWorldSubscribe", "   -filter.version    " + filterVersion);
                this.log.info("HelloWorldSubscribe", "   -filter.query      " + filterQuery);
                this.log.info("HelloWorldSubscribe", "For more info please read:");
                this.log.info("HelloWorldSubscribe", "   http://www.xmlBlaster.org/xmlBlaster/doc/requirements/interface.subscribe.html");
                con = glob.getXmlBlasterAccess();
                this.log.info("HelloWorldSubscribe", "============= CreatingConnectQos");
                ConnectQos qos = new ConnectQos(glob);
                qos.setPersistent(persistentConnection);
                this.log.info("HelloWorldSubscribe", "ConnectQos is " + qos.toXml());
                ConnectReturnQos crq = con.connect(qos, this);
                this.log.info("HelloWorldSubscribe", "Connect success as " + crq.toXml());
                SubscribeKey sk = null;
                String qStr = null;
                if (oid.length() > 0) {
                    sk = new SubscribeKey(glob, oid);
                    qStr = oid;
                } else if (xpath.length() > 0) {
                    sk = new SubscribeKey(glob, xpath, "XPATH");
                    qStr = xpath;
                }
                if (domain.length() > 0) {
                    if (sk == null) {
                        sk = new SubscribeKey(glob, "", "DOMAIN");
                    }
                    sk.setDomain(domain);
                    qStr = domain;
                }
                SubscribeQos sq = new SubscribeQos(glob);
                sq.setWantInitialUpdate(initialUpdate);
                sq.setMultiSubscribe(multiSubscribe);
                sq.setPersistent(persistentSubscribe);
                sq.setWantNotify(notifyOnErase);
                sq.setWantLocal(local);
                sq.setWantContent(wantContent);
                HistoryQos historyQos = new HistoryQos(glob);
                historyQos.setNumEntries(historyNumUpdates);
                historyQos.setNewestFirst(historyNewestFirst);
                sq.setHistoryQos(historyQos);
                if (filterQuery.length() > 0) {
                    AccessFilterQos filter = new AccessFilterQos(glob, filterType, filterVersion, filterQuery);
                    sq.addAccessFilter(filter);
                }
                this.log.info("HelloWorldSubscribe", "SubscribeKey=\n" + sk.toXml());
                this.log.info("HelloWorldSubscribe", "SubscribeQos=\n" + sq.toXml());
                if (interactive) {
                    Global.waitOnKeyboardHit("Hit a key to subscribe '" + qStr + "'");
                }
                SubscribeReturnQos srq = con.subscribe(sk, sq);
                this.log.info("HelloWorldSubscribe", "Subscribed on topic '" + (oid.length() > 0 ? oid : xpath) + "', got subscription id='" + srq.getSubscriptionId() + "'\n" + srq.toXml());
                if (this.log.DUMP) {
                    this.log.dump("", "Subscribed: " + sk.toXml() + sq.toXml() + srq.toXml());
                }
                if (shutdownCbServer) {
                    Global.waitOnKeyboardHit("Hit a key to shutdown callback server");
                    con.getCbServer().shutdown();
                    this.log.info("HelloWorldSubscribe", "Callback server halted, no update should arrive ...");
                } else {
                    this.log.info("HelloWorldSubscribe", "Waiting on update ...");
                }
                if (this.interactiveUpdate) {
                    try {
                        Thread.sleep(1000000000L);
                    }
                    catch (InterruptedException i) {
                        // empty catch block
                    }
                }
                if (unSubscribe) {
                    if (interactive) {
                        Global.waitOnKeyboardHit("Hit a key to unSubscribe");
                    }
                    UnSubscribeKey uk = new UnSubscribeKey(glob, srq.getSubscriptionId());
                    if (domain.length() > 0) {
                        uk.setDomain(domain);
                    }
                    UnSubscribeQos uq = new UnSubscribeQos(glob);
                    this.log.info("HelloWorldSubscribe", "UnSubscribeKey=\n" + uk.toXml());
                    this.log.info("HelloWorldSubscribe", "UnSubscribeQos=\n" + uq.toXml());
                    UnSubscribeReturnQos[] urqArr = con.unSubscribe(uk, uq);
                    this.log.info("HelloWorldSubscribe", "UnSubscribe on " + urqArr.length + " subscriptions done");
                }
                Global.waitOnKeyboardHit("Hit a key to exit");
            }
            catch (XmlBlasterException e) {
                this.log.error("HelloWorldSubscribe", e.getMessage());
                Object var33_36 = null;
                if (con == null) return;
                if (!disconnect) return;
                DisconnectQos dq = new DisconnectQos(glob);
                con.disconnect(dq);
                this.log.info("HelloWorldSubscribe", "Disconnected");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error("HelloWorldSubscribe", e.toString());
                Object var33_37 = null;
                if (con == null) return;
                if (!disconnect) return;
                DisconnectQos dq = new DisconnectQos(glob);
                con.disconnect(dq);
                this.log.info("HelloWorldSubscribe", "Disconnected");
                return;
            }
            Object var33_35 = null;
            if (con == null) return;
            if (!disconnect) return;
            DisconnectQos dq = new DisconnectQos(glob);
            con.disconnect(dq);
        }
        catch (Throwable throwable) {
            Object var33_38 = null;
            if (con == null) throw throwable;
            if (!disconnect) throw throwable;
            DisconnectQos dq = new DisconnectQos(glob);
            con.disconnect(dq);
            this.log.info("HelloWorldSubscribe", "Disconnected");
            throw throwable;
        }
        this.log.info("HelloWorldSubscribe", "Disconnected");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
        ++this.updateCounter;
        System.out.println("");
        System.out.println("============= START #" + this.updateCounter + " '" + updateKey.getOid() + "' =======================");
        this.log.info("HelloWorldSubscribe", "Receiving update #" + this.updateCounter + " of a message ...");
        System.out.println("<xmlBlaster>");
        System.out.println(updateKey.toXml());
        System.out.println("");
        System.out.println("<content size='" + content.length + "'>");
        if (content.length < this.maxContentLength) {
            System.out.println(new String(content));
        } else {
            String str = new String(content, 0, this.maxContentLength - 5);
            System.out.println(str + " ...");
        }
        System.out.println("</content>");
        System.out.println(updateQos.toXml());
        System.out.println("</xmlBlaster>");
        if (this.dumpContent) {
            String fileName = updateKey.getOid() + "-" + updateQos.getRcvTimestamp().getTimestamp();
            try {
                FileUtil.writeFile(fileName, content);
                System.out.println("Dumped content to file '" + fileName + "'");
            }
            catch (JUtilsException e) {
                System.out.println("Can't dump content to file '" + fileName + "': " + e.toString());
            }
        }
        Map map = updateQos.getClientProperties();
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            ClientProperty clientProperty = (ClientProperty)it.next();
            if (!clientProperty.isBase64()) continue;
            System.out.println("\nClientProperty decoded: " + clientProperty.getName() + "='" + clientProperty.getStringValue() + "'");
        }
        System.out.println("============= END #" + this.updateCounter + " '" + updateKey.getOid() + "' =========================");
        System.out.println("");
        if (this.updateSleep > 0L) {
            this.log.info("HelloWorldSubscribe", "Sleeping for " + this.updateSleep + " millis ...");
            try {
                Thread.sleep(this.updateSleep);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            this.log.info("HelloWorldSubscribe", "Waking up.");
        } else if (this.interactiveUpdate) {
            Global.waitOnKeyboardHit("Hit a key to return from update() (we are blocking the server callback) ...");
            this.log.info("HelloWorldSubscribe", "Returning update() - control goes back to server");
        }
        if (this.updateExceptionErrorCode != null) {
            ErrorCode errorCode;
            this.log.info("HelloWorldSubscribe", "Throwing XmlBlasterException with errorCode='" + this.updateExceptionErrorCode + "' back to server ...");
            try {
                errorCode = ErrorCode.toErrorCode(this.updateExceptionErrorCode);
            }
            catch (IllegalArgumentException e) {
                this.log.error("HelloWorldSubscribe", "Please supply a valid exception errorCode (see ErrorCode.java) for instead of -updateException.errorCode " + this.updateExceptionErrorCode + "");
                return "<qos><state id='OK'/></qos>";
            }
            throw new XmlBlasterException(updateKey.getGlobal(), errorCode, "HelloWorldSubscribe", this.updateExceptionMessage);
        }
        if (this.updateExceptionRuntime != null) {
            this.log.info("HelloWorldSubscribe", "Throwing RuntimeException '" + this.updateExceptionRuntime + "'");
            throw new RuntimeException(this.updateExceptionRuntime);
        }
        return "<qos><state id='OK'/></qos>";
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            System.err.println("\nExample:");
            System.err.println("  java javaclients.HelloWorldSubscribe -oid Hello -initialUpdate true\n");
            System.exit(1);
        }
        new HelloWorldSubscribe(glob);
    }
}

