/*
 * Decompiled with CFR 0.152.
 */
package javaclients;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.GetReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.client.qos.UpdateReturnQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.TopicProperty;

public class HelloWorldVolatile2
implements I_Callback {
    private final Global glob;
    private final LogChannel log;

    public HelloWorldVolatile2(Global glob) {
        this.glob = glob;
        this.log = glob.getLog(null);
        try {
            I_XmlBlasterAccess con = glob.getXmlBlasterAccess();
            String name = glob.getProperty().get("session.name", "HelloWorldVolatile2");
            String passwd = glob.getProperty().get("passwd", "secret");
            ConnectQos connectQos = new ConnectQos(glob, name, passwd);
            con.connect(connectQos, this);
            SubscribeKey sk = new SubscribeKey(glob, "HelloWorldVolatile2");
            SubscribeQos sq = new SubscribeQos(glob);
            SubscribeReturnQos subRet = con.subscribe(sk, sq);
            PublishKey pk = new PublishKey(glob, "HelloWorldVolatile2", "text/xml", "1.0");
            PublishQos pq = new PublishQos(glob);
            pq.setVolatile(true);
            TopicProperty topicProperty = new TopicProperty(glob);
            topicProperty.setDestroyDelay(4000L);
            topicProperty.setCreateDomEntry(false);
            pq.setTopicProperty(topicProperty);
            MsgUnit msgUnit = new MsgUnit(pk, "Hi", pq);
            con.publish(msgUnit);
            try {
                GetKey gk = new GetKey(glob, "HelloWorldVolatile2");
                GetQos gq = new GetQos(glob);
                MsgUnit[] msgs = con.get(gk, gq);
                if (msgs.length > 0) {
                    GetReturnQos grq = new GetReturnQos(glob, msgs[0].getQos());
                    this.log.error("", "Did not expect any message as it was volatile");
                }
            }
            catch (XmlBlasterException e) {
                this.log.error("", "Didn't expect an exception in get(): " + e.getMessage());
            }
            DisconnectQos dq = new DisconnectQos(glob);
            con.disconnect(dq);
        }
        catch (XmlBlasterException e) {
            this.log.error("", e.getMessage());
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        if (updateKey.isInternal()) {
            this.log.info("", "Received unexpected internal message '" + updateKey.getOid() + " from xmlBlaster");
            return "";
        }
        this.log.info("", "Received asynchronous message '" + updateKey.getOid() + "' state=" + updateQos.getState() + " content=" + new String(content) + " from xmlBlaster");
        UpdateReturnQos uq = new UpdateReturnQos(this.glob);
        return uq.toXml();
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            System.err.println("Example: java javaclients.HelloWorldVolatile2 -session.name Jeff\n");
            System.exit(1);
        }
        try {
            new HelloWorldVolatile2(glob);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("Unexpected problem: " + e.getMessage());
        }
    }
}

