/*
 * Decompiled with CFR 0.152.
 */
package javaclients;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;

public class Latency
implements I_Callback {
    private long startTime = 0L;
    private boolean messageArrived = false;
    private final LogChannel log;

    public Latency(Global glob) {
        this.log = glob.getLog("client");
        try {
            I_XmlBlasterAccess con = glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(glob);
            con.connect(qos, this);
            PublishKey pk = new PublishKey(glob, "Latency", "text/xml", "1.0");
            PublishQos pq = new PublishQos(glob);
            MsgUnit msgUnit = new MsgUnit(pk.toXml(), "Hi".getBytes(), pq.toXml());
            SubscribeKey sk = new SubscribeKey(glob, "Latency");
            SubscribeQos sq = new SubscribeQos(glob);
            String subId = con.subscribe(sk.toXml(), sq.toXml()).getSubscriptionId();
            int numSend = glob.getProperty().get("numSend", 10);
            int ii = 0;
            while (ii < numSend) {
                this.startTime = System.currentTimeMillis();
                con.publish(msgUnit);
                do {
                    try {
                        Thread.currentThread();
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException i) {
                        // empty catch block
                    }
                } while (!this.messageArrived);
                this.messageArrived = false;
                ++ii;
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            DisconnectQos dq = new DisconnectQos(glob);
            con.disconnect(dq);
        }
        catch (Exception e) {
            this.log.error("", e.toString());
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        long endTime = System.currentTimeMillis();
        this.messageArrived = true;
        this.log.info("", "Received asynchronous message '" + updateKey.getOid() + "' from xmlBlaster - latency=" + (endTime - this.startTime) + " millis");
        return "";
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            Global.instance().usage();
            System.err.println("Example: java javaclients.Latency -loginName Jeff\n");
            System.exit(1);
        }
        new Latency(glob);
    }
}

