/*
 * Decompiled with CFR 0.152.
 */
package javaclients.chat;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.jutils.JUtilsException;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_ConnectionStateListener;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;

public class SimpleChat
extends Frame
implements I_Callback,
ActionListener,
I_ConnectionStateListener {
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess xmlBlasterConnection = null;
    private static String ME = "Mike's TestClient";
    private static String passwd = "some";
    private static String qos = "<qos></qos>";
    private String publishOid = "javaclients.chat.SimpleChat";
    private String xmlKey = null;
    private String logFileName = null;
    private boolean withSound = true;
    private Button connectButton;
    private Button actionButton;
    private Button whoisThereButton;
    private Button soundButton;
    private Panel fPanel;
    private TextArea output;
    private TextField input;
    private Label label;
    private Method speakMethod = null;
    private Object speaker = null;
    static /* synthetic */ Class class$java$lang$String;

    public SimpleChat(Global glob) {
        super(glob.getProperty().get("loginName", "SimpleChat - <NoName>"));
        this.glob = glob;
        this.log = glob.getLog("client");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                SimpleChat.this.logout();
                System.exit(0);
            }
        });
        this.initUI();
        this.pack();
        this.logFileName = glob.getProperty().get("logFile", System.getProperty("user.home") + System.getProperty("file.separator") + "xmlBlasterChat.log");
        this.log.info(ME, "Logging messages to " + this.logFileName);
        try {
            Class<?> speech = Class.forName("com.eclettic.speech.DefaultInputSpeaker");
            Constructor<?> constr = speech.getConstructor(null);
            this.speaker = constr.newInstance(null);
            Class[] argClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SimpleChat.class$("java.lang.String")) : class$java$lang$String};
            this.speakMethod = speech.getMethod("speak", argClasses);
        }
        catch (Throwable ex) {
            this.log.error(ME, "Audio output of messages not activated, please use JDK 1.4 or better and add speech.jar to your classpath: " + ex.toString());
        }
        this.label.setText(this.logFileName);
        this.readOldMessagesFromFile();
    }

    protected void publishMessage(String content) {
        try {
            this.xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='" + this.publishOid + "' contentMime='text/plain'>\n" + "</key>";
            MsgUnit msgUnit = new MsgUnit(this.xmlKey, content.getBytes(), "<qos></qos>");
            this.log.trace(ME, "Publishing ...");
            this.xmlBlasterConnection.publish(msgUnit);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
        }
        this.log.trace(ME, "Publishing done");
    }

    protected void getUserList() {
        if (this.xmlBlasterConnection == null) {
            this.log.error(ME, "Please log in first");
            return;
        }
        this.publishMessage("I am retrieving the connected users list (ignore this)");
        try {
            GetKey getKeyWrapper = new GetKey(this.glob, "__sys__UserList");
            MsgUnit[] msgUnit = this.xmlBlasterConnection.get(getKeyWrapper.toXml(), "<qos></qos>");
            if (msgUnit != null) {
                int i = 0;
                while (i < msgUnit.length) {
                    this.appendOutput("users: " + System.getProperty("line.separator") + new String(msgUnit[i].getContent()) + System.getProperty("line.separator"));
                    ++i;
                }
                this.appendOutput("these where all users connected" + System.getProperty("line.separator"));
            }
        }
        catch (XmlBlasterException ex) {
            this.log.error(ME, "error when getting the list of users");
        }
    }

    public void initUI() {
        this.setLayout(new BorderLayout());
        this.fPanel = new Panel();
        this.fPanel.setLayout(new BorderLayout());
        this.add("North", this.fPanel);
        this.connectButton = new Button("Connect");
        this.connectButton.setActionCommand("connect");
        this.connectButton.addActionListener(this);
        this.fPanel.add((Component)this.connectButton, "West");
        this.label = new Label("LOGGING");
        this.add((Component)this.label, "South");
        this.actionButton = new Button("Send");
        this.actionButton.setActionCommand("send");
        this.actionButton.addActionListener(this);
        this.fPanel.add((Component)this.actionButton, "East");
        this.whoisThereButton = new Button("Who is There ?");
        this.whoisThereButton.setActionCommand("whoisThere");
        this.whoisThereButton.addActionListener(this);
        this.fPanel.add((Component)this.whoisThereButton, "South");
        String soundText = "with Sound";
        if (!this.withSound) {
            soundText = "no Sound";
        }
        this.soundButton = new Button(soundText);
        this.soundButton.setActionCommand("sound");
        this.soundButton.addActionListener(this);
        this.fPanel.add((Component)this.soundButton, "North");
        this.input = new TextField(60);
        this.input.addActionListener(this);
        this.fPanel.add((Component)this.input, "Center");
        this.output = new TextArea("", 12, 80);
        this.output.setEditable(false);
        this.add("Center", this.output);
    }

    public void actionPerformed(ActionEvent ev) {
        String command = ev.getActionCommand();
        Object obj = ev.getSource();
        if ("whoisThere".equals(command)) {
            this.getUserList();
            return;
        }
        if ("sound".equals(command)) {
            if (this.withSound) {
                this.withSound = false;
                this.soundButton.setLabel("no Sound");
                this.fPanel.repaint();
            } else {
                this.withSound = true;
                this.soundButton.setLabel("with Sound");
                this.fPanel.repaint();
            }
        }
        if (command.equals("connect")) {
            if (this.connectButton.getLabel().equals("Connect")) {
                this.initBlaster();
                this.connectButton.setLabel("Logout");
            } else if (this.connectButton.getLabel().equals("Logout")) {
                this.logout();
                this.connectButton.setLabel("Connect");
            }
        } else if (command.equals("send") || ev.getSource() instanceof TextField) {
            if (this.xmlBlasterConnection == null) {
                this.log.error(ME, "Please log in first");
                return;
            }
            String content = this.input.getText();
            this.publishMessage(content);
            this.input.setText("");
        }
    }

    public void appendOutput(String text) {
        this.output.append(text);
        try {
            FileUtil.appendToFile(this.logFileName, text);
        }
        catch (JUtilsException e) {
            this.log.warn(ME, "Can't log message:" + e.toString());
        }
        this.repaint();
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        String msgContent = new String(content);
        if (this.withSound) {
            Toolkit.getDefaultToolkit().beep();
            if (this.speakMethod != null && this.speaker != null) {
                try {
                    Object[] args = new Object[]{msgContent};
                    this.speakMethod.invoke(this.speaker, args);
                }
                catch (Throwable ex) {
                    this.log.error(ME, "Audio output of messages not activated, please use JDK 1.4 or better and add speech.jar to your classpath: " + ex.toString());
                }
            }
            this.toFront();
        }
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        String text = df.format(new Date());
        text = text + "[" + updateQos.getSender() + "]: ";
        text = text + msgContent;
        this.appendOutput(text + System.getProperty("line.separator"));
        this.log.info(ME, "CallBack\n");
        return "";
    }

    public void initBlaster() {
        try {
            this.xmlBlasterConnection = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob);
            this.xmlBlasterConnection.connect(qos, this);
            this.xmlBlasterConnection.registerConnectionListener(this);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
        this.subscription();
    }

    private void readOldMessagesFromFile() {
        try {
            String data = FileUtil.readAsciiFile(this.logFileName);
            StringTokenizer st = new StringTokenizer(data, "\n");
            while (st.hasMoreTokens()) {
                String tmp = st.nextToken();
                this.output.append(tmp + System.getProperty("line.separator"));
            }
        }
        catch (JUtilsException e) {
            this.log.warn(ME, "Can't read old logs from " + this.logFileName + ": " + e.toString());
        }
    }

    public void subscription() {
        try {
            this.log.trace(ME, "Subscribing using the exact oid ...");
            String xmlKeyPub = "<key oid='" + this.publishOid + "' queryType='EXACT'>\n" + "</key>";
            this.xmlBlasterConnection.subscribe(xmlKeyPub, "<qos></qos>");
            this.log.trace(ME, "Subscribed to '" + this.publishOid + "' ...");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
        }
    }

    public void logout() {
        if (this.xmlBlasterConnection == null) {
            return;
        }
        if (this.xmlKey != null) {
            this.log.trace(ME, "Unsubscribe ...");
            try {
                this.xmlBlasterConnection.unSubscribe(this.xmlKey, qos);
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            this.log.info(ME, "Unsubscribe done");
        }
        this.log.trace(ME, "Logout ...");
        this.xmlBlasterConnection.disconnect(null);
    }

    private static void usage(Global glob) {
        System.out.println(glob.usage());
        System.err.println("Example: java javaclients.chat.SimpleChat -loginName Heidi");
        System.exit(1);
    }

    public void reachedAlive(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.subscription();
        if (connection.getQueue().getNumOfEntries() > 0L) {
            this.log.info(ME, "We were lucky, reconnected to xmlBlaster, sending backup " + connection.getQueue().getNumOfEntries() + " messages ...");
        } else {
            this.log.info(ME, "We were lucky, reconnected to xmlBlaster, no backup messages to flush");
        }
    }

    public void reachedPolling(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.warn(ME, "I_ConnectionStateListener: Lost connection to xmlBlaster");
    }

    public void reachedDead(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.warn(ME, "I_ConnectionStateListener: DEAD - Lost connection to xmlBlaster, giving up.");
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            SimpleChat.usage(glob);
            System.exit(1);
        }
        SimpleChat chat = new SimpleChat(glob);
        ((Component)chat).setSize(460, 350);
        chat.show();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

