/*
 * Decompiled with CFR 0.152.
 */
package javaclients.cluster;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.def.PriorityEnum;

public class PublishToSlave
implements I_Callback {
    private final LogChannel log;

    /*
     * Loose catch block
     */
    public PublishToSlave(Global glob) {
        block17: {
            this.log = glob.getLog("client");
            I_XmlBlasterAccess con = null;
            con = glob.getXmlBlasterAccess();
            this.log.info("", "Usage example: java javaclients.cluster.PublishToSlave -bootstrapPort 7601 -numPublish 1000 -interactivePublish false");
            String domain = glob.getProperty().get("domain", "RUGBY_NEWS");
            String content = glob.getProperty().get("content", "We win");
            int numPublish = glob.getProperty().get("numPublish", 1);
            boolean interactivePublish = glob.getProperty().get("interactivePublish", true);
            ConnectQos qos = new ConnectQos(glob);
            ConnectReturnQos conRetQos = con.connect(qos, this);
            this.log.info("PublishToSlave", "Connected to xmlBlaster.");
            PublishKey pk = new PublishKey(glob, "PublishToSlave." + domain, "text/xml", "1.0");
            pk.setDomain(domain);
            PublishQos pq = new PublishQos(glob);
            pq.setPriority(PriorityEnum.LOW_PRIORITY);
            int i = 0;
            while (i < numPublish) {
                if (interactivePublish) {
                    System.out.println("Hit a key to publish ...");
                    try {
                        System.in.read();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                MsgUnit msgUnit = new MsgUnit(pk.toXml(), content.getBytes(), pq.toXml());
                PublishReturnQos retQos = con.publish(msgUnit);
                this.log.info("PublishToSlave", "Published #" + (i + 1) + " message oid=" + pk.getOid() + " of domain='" + pk.getDomain() + "' and content='" + content + "' to xmlBlaster node with IP=" + glob.getProperty().get("bootstrapPort", 0) + ", the returned QoS is: " + retQos.getKeyOid());
                ++i;
            }
            Object var15_16 = null;
            System.out.println("Hit a key to quit ...");
            try {
                System.in.read();
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (con != null) {
                DisconnectQos dq = new DisconnectQos(glob);
                con.disconnect(dq);
            }
            break block17;
            {
                catch (Exception e) {
                    this.log.error("PublishToSlave-Exception", e.toString());
                    Object var15_17 = null;
                    System.out.println("Hit a key to quit ...");
                    try {
                        System.in.read();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (con != null) {
                        DisconnectQos dq = new DisconnectQos(glob);
                        con.disconnect(dq);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                System.out.println("Hit a key to quit ...");
                try {
                    System.in.read();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (con != null) {
                    DisconnectQos dq = new DisconnectQos(glob);
                    con.disconnect(dq);
                }
                throw throwable;
            }
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info("PublishToSlave", "Received asynchronous message '" + updateKey.getOid() + "' from xmlBlaster");
        return "";
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            System.err.println("Example: java javaclients.cluster.PublishToSlave -bootstrapPort 7601 -domain STOCK_EXCHANGE -content 'We win'\n");
            System.exit(1);
        }
        new PublishToSlave(glob);
    }
}

