/*
 * Decompiled with CFR 0.152.
 */
package javaclients.corba;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.protocol.corba.CorbaDriver;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallbackOperations;
import org.xmlBlaster.protocol.corba.serverIdl.MessageUnit;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;

public class BlasterCallbackImpl
implements BlasterCallbackOperations {
    final String ME;
    private final Global glob;
    private final LogChannel log;

    public BlasterCallbackImpl(String name) {
        this.ME = "BlasterCallbackImpl-" + name;
        this.glob = Global.instance();
        this.log = this.glob.getLog("client");
        if (this.log.CALL) {
            this.log.trace(this.ME, "Entering constructor with argument");
        }
    }

    public BlasterCallbackImpl() {
        this("");
    }

    public String[] update(String cbSessionId, MessageUnit[] corbaMsgUnitArr) {
        this.log.info(this.ME, "#================== BlasterCallback update START =============");
        this.log.info(this.ME, "cbSessionId=" + cbSessionId);
        String[] ret = new String[corbaMsgUnitArr.length];
        try {
            MsgUnitRaw[] msgUnitArr = CorbaDriver.convert(this.glob, corbaMsgUnitArr);
            int ii = 0;
            while (ii < msgUnitArr.length) {
                MsgUnitRaw msgUnit = msgUnitArr[ii];
                UpdateKey xmlKey = null;
                try {
                    xmlKey = new UpdateKey(null, msgUnit.getKey());
                }
                catch (XmlBlasterException e) {
                    this.log.error(this.ME, e.getMessage());
                }
                this.log.info(this.ME, "Callback invoked for " + xmlKey.toString() + " content length = " + msgUnit.getContent().length);
                this.log.info(this.ME, new String(msgUnit.getContent()));
                ret[ii] = "<qos><state id='OK'/></qos>";
                ++ii;
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, e.getMessage());
        }
        this.log.info(this.ME, "#================== BlasterCallback update END ===============");
        return ret;
    }

    public void updateOneway(String cbSessionId, MessageUnit[] msgUnitArr) {
        try {
            this.update(cbSessionId, msgUnitArr);
        }
        catch (Throwable e) {
            this.log.error(this.ME, "updateOneway() failed, exception is not sent to xmlBlaster: " + e.toString());
            e.printStackTrace();
        }
    }

    public String ping(String qos) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering ping() ...");
        }
        return "";
    }
}

