/*
 * Decompiled with CFR 0.152.
 */
package javaclients.corba;

import java.io.IOException;
import javaclients.corba.RawCallback;
import org.jutils.init.Args;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.omg.CORBA.ORB;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.xmlBlaster.protocol.corba.authenticateIdl.AuthServer;
import org.xmlBlaster.protocol.corba.authenticateIdl.AuthServerHelper;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallback;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallbackHelper;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallbackPOATie;
import org.xmlBlaster.protocol.corba.serverIdl.MessageUnit;
import org.xmlBlaster.protocol.corba.serverIdl.Server;
import org.xmlBlaster.protocol.corba.serverIdl.XmlBlasterException;
import org.xmlBlaster.util.Global;

public class ClientRaw {
    private static String ME = "ClientRaw";
    private final ORB orb;
    private final String[] args;
    private final LogChannel log;
    private Server xmlBlaster = null;

    public ClientRaw(String[] args) {
        this.args = args;
        System.out.println("   -dispatch/connection/plugin/ior/iorString  The raw IOR string from xmlBlaster.");
        System.out.println("   -dispatch/connection/plugin/ior/iorFile    The raw IOR string from a file.");
        Global glob = new Global(args);
        this.log = glob.getLog("client");
        this.orb = ORB.init(this.args, null);
        try {
            AuthServer authServer;
            String loginName = ME = Args.getArg(this.args, "-loginName", ME);
            String fileName = Args.getArg(this.args, "-dispatch/connection/plugin/ior/iorFile", (String)null);
            String authServerIOR = Args.getArg(this.args, "-dispatch/connection/plugin/ior/iorString", (String)null);
            if (fileName != null) {
                authServerIOR = FileUtil.readAsciiFile(fileName);
            }
            if (authServerIOR != null) {
                authServer = AuthServerHelper.narrow(this.orb.string_to_object(authServerIOR));
            } else {
                NamingContext nc = NamingContextHelper.narrow(this.orb.resolve_initial_references("NameService"));
                NameComponent[] name = new NameComponent[]{new NameComponent()};
                name[0].id = "xmlBlaster-Authenticate";
                name[0].kind = "MOM";
                if (nc == null) {
                    this.log.plain(ME, "\nSorry, please pass the server IOR string to the client, e.g.:\nStart the server:\n   jaco org.xmlBlaster.Main -dispatch/connection/plugin/ior/iorFile /tmp/NS_Ref\nStart this client:\n   jaco javaclients.corba.ClientRaw -dispatch/connection/plugin/ior/iorFile /tmp/NS_Ref\n");
                    ClientRaw.usage();
                    System.err.println(ME + ": Read xmlBlaster/INSTALL for help");
                    System.exit(1);
                }
                authServer = AuthServerHelper.narrow(nc.resolve(name));
            }
            StopWatch stop = new StopWatch();
            POA rootPOA = POAHelper.narrow(this.orb.resolve_initial_references("RootPOA"));
            BlasterCallbackPOATie callbackTie = new BlasterCallbackPOATie(new RawCallback(args, ME));
            BlasterCallback callback = BlasterCallbackHelper.narrow(rootPOA.servant_to_reference(callbackTie));
            rootPOA.the_POAManager().activate();
            try {
                String passwd = "some";
                String qos = "<qos><callback type='IOR'>";
                qos = qos + this.orb.object_to_string(callback);
                qos = qos + "</callback></qos>";
                this.xmlBlaster = authServer.login(loginName, passwd, qos);
                this.log.info(ME, "Login done");
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            this.log.trace(ME, "Subscribing using XPath syntax ...");
            String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='' queryType='XPATH'>\n/xmlBlaster/key/AGENT</key>";
            stop.restart();
            try {
                this.xmlBlaster.subscribe(xmlKey, "<qos></qos>");
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            this.log.info(ME, "Subscribe done, there should be no Callback" + stop.nice());
            this.delay(2000L);
            xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='' contentMime='text/xml'>\n  <AGENT id='192.168.124.10' subId='1' type='generic'>    <DRIVER id='FileProof' pollingFreq='10'>    </DRIVER>  </AGENT></key>";
            String content = "Yeahh, i'm the new content";
            MessageUnit msgUnit = new MessageUnit(xmlKey, content.getBytes(), "<qos></qos>");
            this.log.info(ME, "Publishing ...");
            stop.restart();
            try {
                String publishOid = this.xmlBlaster.publish(msgUnit);
                this.log.trace(ME, "Returned oid=" + publishOid);
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            this.log.info(ME, "Publishing done, there should be a callback now" + stop.nice());
            this.delay(1000L);
            this.ask("logout()");
            this.log.info(ME, "Logout ...");
            try {
                authServer.logout(this.xmlBlaster);
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            try {
                rootPOA.deactivate_object(rootPOA.reference_to_id(callback));
            }
            catch (Exception e) {
                this.log.warn(ME, "POA deactivate callback failed");
            }
            try {
                rootPOA.the_POAManager().deactivate(false, true);
            }
            catch (Exception e) {
                this.log.warn(ME, "POA deactivate failed");
            }
            this.orb.shutdown(true);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    private void delay(long millis) {
        try {
            Thread.currentThread();
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void ask(String text) {
        this.log.plain(ME, text);
        this.log.plain(ME, "################### Hit a key to continue ###################");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void usage() {
        System.out.println("\nAvailable options:");
        System.out.println("   -loginName                               The login name [ClientRaw].");
        System.out.println("   -dispatch/connection/plugin/ior/iorFile  File with the IOR string from xmlBlaster.");
        System.out.println("   -dispatch/callback/plugin/ior/iorString  The raw IOR string from xmlBlaster.");
        System.out.println("Example: jaco javaclients.corba.ClientRaw -dispatch/connection/plugin/ior/iorFile /tmp/NS_Ref\n");
        System.exit(1);
    }

    public static void main(String[] args) {
        new ClientRaw(args);
    }
}

