/*
 * Decompiled with CFR 0.152.
 */
package javaclients.corba;

import java.io.IOException;
import org.jutils.init.Args;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.omg.CORBA.ORB;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.protocol.corba.authenticateIdl.AuthServer;
import org.xmlBlaster.protocol.corba.authenticateIdl.AuthServerHelper;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallback;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallbackHelper;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallbackOperations;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallbackPOATie;
import org.xmlBlaster.protocol.corba.serverIdl.MessageUnit;
import org.xmlBlaster.protocol.corba.serverIdl.Server;
import org.xmlBlaster.protocol.corba.serverIdl.ServerHelper;
import org.xmlBlaster.protocol.corba.serverIdl.XmlBlasterException;
import org.xmlBlaster.util.Global;

public class ClientRawSecurity {
    private static String ME = "ClientRawSecurity";
    private final Global glob;
    private final LogChannel log;
    private final ORB orb;
    private Server xmlBlaster = null;

    public ClientRawSecurity(String[] args) {
        this.glob = new Global(args);
        this.log = this.glob.getLog(null);
        this.orb = ORB.init(args, null);
        try {
            AuthServer authServer;
            String loginName = ME = Args.getArg(args, "-loginName", ME);
            String fileName = Args.getArg(args, "-dispatch/connection/plugin/ior/iorFile", (String)null);
            String authServerIOR = Args.getArg(args, "-dispatch/connection/plugin/ior/iorString", (String)null);
            if (fileName != null) {
                authServerIOR = FileUtil.readAsciiFile(fileName);
            }
            if (authServerIOR != null) {
                authServer = AuthServerHelper.narrow(this.orb.string_to_object(authServerIOR));
            } else {
                NamingContext nc = NamingContextHelper.narrow(this.orb.resolve_initial_references("NameService"));
                NameComponent[] name = new NameComponent[]{new NameComponent()};
                name[0].id = "xmlBlaster-Authenticate";
                name[0].kind = "MOM";
                if (nc == null) {
                    this.log.plain(ME, "\nSorry, please pass the server IOR string to the client, e.g.:\nStart the server:\n   jaco org.xmlBlaster.Main -dispatch/connection/plugin/ior/iorFile /tmp/NS_Ref\nStart this client:\n   jaco javaclients.corba.ClientRawSecurity -dispatch/connection/plugin/ior/iorFile /tmp/NS_Ref\n");
                    ClientRawSecurity.usage();
                    this.log.error(ME, "Read xmlBlaster/INSTALL for help");
                    System.exit(1);
                }
                authServer = AuthServerHelper.narrow(nc.resolve(name));
            }
            StopWatch stop = new StopWatch();
            POA rootPOA = POAHelper.narrow(this.orb.resolve_initial_references("RootPOA"));
            BlasterCallbackPOATie callbackTie = new BlasterCallbackPOATie(new RawCallback(this.glob, ME));
            BlasterCallback callback = BlasterCallbackHelper.narrow(rootPOA.servant_to_reference(callbackTie));
            rootPOA.the_POAManager().activate();
            try {
                String passwd = "some";
                String callbackIOR = this.orb.object_to_string(callback);
                String qos = "<qos>\n   <securityService type=\"simple\" version=\"1.0\">\n      <user>" + loginName + "</user>\n" + "      <passwd>" + passwd + "</passwd>\n" + "   </securityService>\n" + "   <callback type='IOR'>\n" + callbackIOR + "\n" + "   </callback>\n" + "</qos>\n";
                String retXml = authServer.connect(qos);
                ConnectReturnQos returnQos = new ConnectReturnQos(this.glob, retXml);
                this.log.info(ME, "Login (Connect) done.");
                this.log.info(ME, "Used QoS=\n" + qos);
                this.log.info(ME, "Returned QoS=\n" + returnQos.toXml());
                String xmlBlasterIOR = returnQos.getServerRef().getAddress();
                this.xmlBlaster = ServerHelper.narrow(this.orb.string_to_object(xmlBlasterIOR));
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            this.log.trace(ME, "Subscribing using XPath syntax ...");
            String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='' queryType='XPATH'>\n/xmlBlaster/key/AGENT</key>";
            stop.restart();
            try {
                this.xmlBlaster.subscribe(xmlKey, "<qos></qos>");
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            this.log.info(ME, "Subscribe done, there should be no Callback" + stop.nice());
            this.delay(2000L);
            xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='' contentMime='text/xml'>\n  <AGENT id='192.168.124.10' subId='1' type='generic'>    <DRIVER id='FileProof' pollingFreq='10'>    </DRIVER>  </AGENT></key>";
            String content = "Yeahh, i'm the new content";
            MessageUnit msgUnit = new MessageUnit(xmlKey, content.getBytes(), "<qos></qos>");
            this.log.info(ME, "Publishing ...");
            stop.restart();
            try {
                String publishOid = this.xmlBlaster.publish(msgUnit);
                this.log.trace(ME, "Returned oid=" + publishOid);
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            this.log.info(ME, "Publishing done, there should be a callback now" + stop.nice());
            this.delay(1000L);
            this.ask("logout()");
            this.log.info(ME, "Logout ...");
            try {
                authServer.logout(this.xmlBlaster);
                authServer._release();
                this.xmlBlaster._release();
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            try {
                callback._release();
                rootPOA.deactivate_object(rootPOA.reference_to_id(callback));
            }
            catch (Exception e) {
                this.log.warn(ME, "POA deactivate callback failed");
            }
            try {
                rootPOA.the_POAManager().deactivate(false, true);
            }
            catch (Exception e) {
                this.log.warn(ME, "POA deactivate failed");
            }
            this.orb.shutdown(true);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    private void delay(long millis) {
        try {
            Thread.currentThread();
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void ask(String text) {
        System.out.println(text);
        System.out.println("################### Hit a key to continue ###################");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void usage() {
        System.out.println("\nAvailable options:");
        System.out.println("   -loginName                                The login name [ClientRawSecurity].");
        System.out.println("   -dispatch/connection/plugin/ior/iorFile   File with the IOR string from xmlBlaster.");
        System.out.println("   -dispatch/callback/plugin/ior/iorString   The raw IOR string from xmlBlaster.");
        Global.instance().usage();
        System.err.println("Example: jaco javaclients.corba.ClientRawSecurity -dispatch/connection/plugin/ior/iorFile /tmp/NS_Ref\n");
        System.exit(1);
    }

    public static void main(String[] args) {
        new ClientRawSecurity(args);
    }

    private class RawCallback
    implements BlasterCallbackOperations {
        final String ME;
        final Global glob;
        final LogChannel log;

        public RawCallback(Global glob, String name) {
            this.glob = glob;
            this.log = glob.getLog("client");
            this.ME = "RawCallback-" + name;
            if (this.log.CALL) {
                this.log.trace(this.ME, "Entering constructor with argument");
            }
        }

        public String[] update(String sessionId, MessageUnit[] msgUnitArr) {
            String[] ret = new String[msgUnitArr.length];
            int ii = 0;
            while (ii < msgUnitArr.length) {
                MessageUnit msgUnit = msgUnitArr[ii];
                System.out.println("\n================== BlasterCallback update START =============");
                System.out.println("Callback invoked for " + msgUnit.xmlKey + " content length = " + msgUnit.content.length);
                System.out.println(new String(msgUnit.content));
                System.out.println("================== BlasterCallback update END ===============\n");
                ret[ii] = "<qos><state id='OK'/></qos>";
                ++ii;
            }
            return ret;
        }

        public void updateOneway(String cbSessionId, MessageUnit[] msgUnitArr) {
            try {
                this.update(cbSessionId, msgUnitArr);
            }
            catch (Throwable e) {
                this.log.error(this.ME, "updateOneway() failed, exception is not sent to xmlBlaster: " + e.toString());
                e.printStackTrace();
            }
        }

        public String ping(String qos) {
            if (this.log.CALL) {
                this.log.call(this.ME, "Entering ping() ...");
            }
            return "";
        }
    }
}

