/*
 * Decompiled with CFR 0.152.
 */
package javaclients.corba;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallbackOperations;
import org.xmlBlaster.protocol.corba.serverIdl.MessageUnit;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

class RawCallback
implements BlasterCallbackOperations {
    final String ME;
    final Global glob;
    final LogChannel log;

    public RawCallback(String[] args, String name) {
        this.ME = "RawCallback-" + name;
        this.glob = new Global(args);
        this.log = this.glob.getLog("client");
        if (this.log.CALL) {
            this.log.trace(this.ME, "Entering constructor with argument");
        }
    }

    public String[] update(String cbSessionId, MessageUnit[] msgUnitArr) {
        String[] ret = new String[msgUnitArr.length];
        int ii = 0;
        while (ii < msgUnitArr.length) {
            MessageUnit msgUnit = msgUnitArr[ii];
            UpdateKey key = null;
            UpdateQos qos = null;
            try {
                key = new UpdateKey(this.glob, msgUnit.xmlKey);
                qos = new UpdateQos(this.glob, msgUnit.qos);
            }
            catch (XmlBlasterException e) {
                this.log.error(this.ME, e.getMessage());
            }
            this.log.plain(this.ME, "\n================== BlasterCallback update START =============");
            this.log.plain(this.ME, "Callback invoked for " + key.toString() + " content length = " + msgUnit.content.length);
            this.log.plain(this.ME, new String(msgUnit.content));
            this.log.plain(this.ME, "================== BlasterCallback update END ===============\n");
            ret[ii] = "<qos><state id='OK'/></qos>";
            ++ii;
        }
        return ret;
    }

    public void updateOneway(String cbSessionId, MessageUnit[] msgUnitArr) {
        try {
            this.update(cbSessionId, msgUnitArr);
        }
        catch (Throwable e) {
            this.log.error(this.ME, "updateOneway() failed, exception is not sent to xmlBlaster: " + e.toString());
            e.printStackTrace();
        }
    }

    public String ping(String qos) {
        return "";
    }
}

