/*
 * Decompiled with CFR 0.152.
 */
package javaclients.graphical;

import CH.ifa.draw.contrib.DiamondFigure;
import CH.ifa.draw.contrib.MDI_DrawApplication;
import CH.ifa.draw.contrib.PolygonTool;
import CH.ifa.draw.contrib.TextAreaFigure;
import CH.ifa.draw.contrib.TextAreaTool;
import CH.ifa.draw.contrib.TriangleFigure;
import CH.ifa.draw.contrib.html.HTMLTextAreaFigure;
import CH.ifa.draw.contrib.html.HTMLTextAreaTool;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.LineFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.util.UndoableTool;
import java.awt.Component;
import javaclients.graphical.XmlBlasterDrawing;
import javax.swing.JToolBar;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;

public class GraphicChat
extends MDI_DrawApplication
implements I_Callback {
    private Global global;
    private LogChannel log;
    private String ME = "GraphicChat";
    private I_XmlBlasterAccess accessor;

    public GraphicChat(Global global) {
        super("GraphicChat");
        this.global = global;
        this.log = this.global.getLog("main");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(this.ME, "update for '" + cbSessionId + "', '" + updateKey.getOid() + "' length of msg is '" + content.length + "'");
        return "OK";
    }

    protected void init() {
        this.accessor = this.global.getXmlBlasterAccess();
    }

    protected Drawing createDrawing() {
        XmlBlasterDrawing drawing = new XmlBlasterDrawing(this.global);
        return drawing;
    }

    protected void createTools(JToolBar palette) {
        super.createTools(palette);
        UndoableTool tool = new UndoableTool((Tool)new TextTool((DrawingEditor)this, (Figure)new TextFigure()));
        palette.add((Component)this.createToolButton("/CH/ifa/draw/images/TEXT", "Text Tool", (Tool)tool));
        tool = new UndoableTool((Tool)new CreationTool((DrawingEditor)this, (Figure)new RectangleFigure()));
        palette.add((Component)this.createToolButton("/CH/ifa/draw/images/RECT", "Rectangle Tool", (Tool)tool));
        tool = new UndoableTool((Tool)new CreationTool((DrawingEditor)this, (Figure)new RoundRectangleFigure()));
        palette.add((Component)this.createToolButton("/CH/ifa/draw/images/RRECT", "Round Rectangle Tool", (Tool)tool));
        tool = new UndoableTool((Tool)new CreationTool((DrawingEditor)this, (Figure)new EllipseFigure()));
        palette.add((Component)this.createToolButton("/CH/ifa/draw/images/ELLIPSE", "Ellipse Tool", (Tool)tool));
        tool = new UndoableTool((Tool)new PolygonTool((DrawingEditor)this));
        palette.add((Component)this.createToolButton("/CH/ifa/draw/images/POLYGON", "Polygon Tool", (Tool)tool));
        tool = new UndoableTool((Tool)new CreationTool((DrawingEditor)this, (Figure)new TriangleFigure()));
        palette.add((Component)this.createToolButton("/CH/ifa/draw/images/TRIANGLE", "Triangle Tool", (Tool)tool));
        tool = new UndoableTool((Tool)new CreationTool((DrawingEditor)this, (Figure)new DiamondFigure()));
        palette.add((Component)this.createToolButton("/CH/ifa/draw/images/DIAMOND", "Diamond Tool", (Tool)tool));
        tool = new UndoableTool((Tool)new CreationTool((DrawingEditor)this, (Figure)new LineFigure()));
        palette.add((Component)this.createToolButton("/CH/ifa/draw/images/LINE", "Line Tool", (Tool)tool));
        tool = new TextAreaTool((DrawingEditor)this, (Figure)new TextAreaFigure());
        palette.add((Component)this.createToolButton("/CH/ifa/draw/images/TEXTAREA", "TextArea Tool", (Tool)tool));
        tool = new HTMLTextAreaTool((DrawingEditor)this, (Figure)new HTMLTextAreaFigure());
        palette.add((Component)this.createToolButton("/CH/ifa/draw/images/TEXTAREA", "HTML TextArea Tool", (Tool)tool));
    }

    protected void destroy() {
        this.log.info(this.ME, "destroy invoked");
        DrawingView[] views = this.views();
        int i = 0;
        while (i < views.length) {
            views[i].drawing().release();
            ++i;
        }
        super.destroy();
    }

    protected void fireViewDestroyingEvent(DrawingView view) {
        this.log.info(this.ME, "Destroying view '" + view.drawing().getTitle() + "'");
        Drawing drawing = view.drawing();
        super.fireViewDestroyingEvent(view);
        drawing.release();
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            System.err.println("Example: java javaclients.graphical.GraphicChat -chatMaster true\n");
            System.exit(1);
        }
        GraphicChat window = new GraphicChat(glob);
        window.open();
    }
}

