/*
 * Decompiled with CFR 0.152.
 */
package javaclients.graphical;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class MonitorCommand {
    public static final int NONE = 0;
    public static final int LOCATION = 1;
    public static final int SIZE = 2;
    public static final int COLOR = 4;
    public static final int TEXT = 8;
    public static final String ME = "MonitorCommand";
    private Global global;
    private LogChannel log;
    private String oid;
    private String type;
    private int action = 0;
    private Figure figure;

    private MonitorCommand(Global global, String oid, int action, Figure figure) {
        this.global = global;
        this.log = this.global.getLog("monitor");
        this.oid = oid;
        this.action = action;
        this.figure = figure;
    }

    public MonitorCommand(Global global, String txt, Figure figure) throws XmlBlasterException {
        this.global = global;
        this.log = this.global.getLog("monitor");
        this.figure = figure;
        StringTokenizer tokenizer = new StringTokenizer(txt.trim(), ";");
        if (tokenizer.countTokens() != 3) {
            throw new XmlBlasterException(this.global, ErrorCode.USER_CONFIGURATION, "The text '" + txt + "' is not recognized as a valid command");
        }
        String type = tokenizer.nextToken().trim();
        if ("&instance".equalsIgnoreCase(type)) {
            this.oid = tokenizer.nextToken().trim();
        } else if ("&template".equalsIgnoreCase(type)) {
            this.type = tokenizer.nextToken().trim();
        } else {
            throw new XmlBlasterException(this.global, ErrorCode.USER_CONFIGURATION, "The text '" + txt + "' must either start with '&instance' or '&template'");
        }
        String tmp = tokenizer.nextToken().trim();
        if ("location".equalsIgnoreCase(tmp)) {
            this.action = 1;
        } else if ("size".equalsIgnoreCase(tmp)) {
            this.action = 2;
        } else if ("color".equalsIgnoreCase(tmp)) {
            this.action = 4;
        } else if ("text".equalsIgnoreCase(tmp)) {
            this.action = 8;
        } else {
            throw new XmlBlasterException(this.global, ErrorCode.USER_CONFIGURATION, "The action (here) '" + tmp + "' must either be 'location', 'size', 'color' or 'text'");
        }
    }

    public boolean isInstance() {
        return this.oid != null;
    }

    public boolean isTemplate() {
        return this.type != null;
    }

    public String getOid() {
        return this.oid;
    }

    public String getType() {
        return this.type;
    }

    public int getAction() {
        return this.action;
    }

    public Figure getFigure() {
        return this.figure;
    }

    public void doAction(byte[] content, DrawingView view) {
        String data = new String(content);
        Rectangle oldRect = this.figure.displayBox();
        try {
            if (this.action == 1) {
                StringTokenizer tokenizer = new StringTokenizer(data.trim(), ";");
                int x = Integer.parseInt(tokenizer.nextToken().trim());
                int y = Integer.parseInt(tokenizer.nextToken().trim());
                this.figure.moveBy(x - oldRect.x, y - oldRect.y);
                if (this.log.TRACE) {
                    this.log.trace(ME, "new position: " + x + " " + y);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Rectangle newRect = this.figure.displayBox();
        Drawing drawing = view.drawing();
        FigureChangeEvent ev0 = new FigureChangeEvent(this.figure);
        drawing.figureChanged(ev0);
        DrawingChangeEvent ev = new DrawingChangeEvent(drawing, oldRect);
        view.drawingRequestUpdate(ev);
        ev = new DrawingChangeEvent(drawing, newRect);
        view.drawingRequestUpdate(ev);
    }

    public MonitorCommand createInstance(String oid) {
        if (!this.isTemplate()) {
            return null;
        }
        Figure fig = (Figure)this.figure.clone();
        return new MonitorCommand(this.global, oid, this.action, fig);
    }

    public void remove(DrawingView view) {
        Drawing drawing = view.drawing();
        drawing.remove(this.figure);
        drawing.orphan(this.figure);
        FigureChangeEvent ev = new FigureChangeEvent(this.figure);
        drawing.figureRequestUpdate(ev);
    }

    public static void main(String[] args) {
        String txt = "&instance;plane.110;LOCATION";
        try {
            MonitorCommand command = new MonitorCommand(new Global(), txt, null);
            System.out.println("is instance: " + command.isInstance());
            System.out.println("is template: " + command.isTemplate());
            if (command.isInstance()) {
                System.out.println("oid: " + command.getOid());
            }
            if (command.isTemplate()) {
                System.out.println("type: " + command.getType());
            }
            System.out.println("action: " + command.getAction());
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }
}

