/*
 * Decompiled with CFR 0.152.
 */
package javaclients.graphical;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.util.ArrayList;
import java.util.HashMap;
import javaclients.graphical.MonitorCommand;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;

public class MonitorSubscriber
implements I_Callback {
    private static final String ME = "MonitorSubscriber";
    private Global global;
    private LogChannel log;
    private boolean isRunning;
    private HashMap cmdInstances;
    private HashMap cmdTemplates;
    private HashMap dynamicInstances;
    private DrawingView view;

    public MonitorSubscriber(Global glob, DrawingView view) {
        this.global = glob.getClone(null);
        this.isRunning = false;
        this.log = this.global.getLog("monitor");
        this.cmdInstances = new HashMap();
        this.cmdTemplates = new HashMap();
        this.dynamicInstances = new HashMap();
        this.view = view;
    }

    private boolean isCommand(String txt) {
        return txt.startsWith("&");
    }

    private String[] getAssociatedTexts(Figure fig) {
        if (fig == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        FigureEnumeration enumer = fig.figures();
        while (enumer.hasNextFigure()) {
            String txt;
            Figure fig1 = enumer.nextFigure();
            if (fig1.getTextHolder() == null || !this.isCommand(txt = fig1.getTextHolder().getText())) continue;
            list.add(txt);
        }
        if (list.size() < 1) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    private boolean prepareClient(Drawing drawing) {
        FigureEnumeration enumer = drawing.figures();
        boolean ret = false;
        while (enumer.hasNextFigure()) {
            Figure fig = enumer.nextFigure();
            String[] txt = this.getAssociatedTexts(fig);
            if (txt == null) continue;
            int i = 0;
            while (i < txt.length) {
                try {
                    MonitorCommand cmd = new MonitorCommand(this.global, txt[i], fig);
                    if (cmd.isInstance()) {
                        this.cmdInstances.put(cmd.getOid(), cmd);
                    } else if (cmd.isTemplate()) {
                        this.cmdTemplates.put(cmd.getType(), cmd);
                    }
                    ret = true;
                }
                catch (Exception ex) {
                    this.log.warn(ME, ex.getMessage());
                }
                ++i;
            }
        }
        return ret;
    }

    public synchronized boolean start(String name) {
        if (this.isRunning) {
            return true;
        }
        try {
            int i;
            if (!this.prepareClient(this.view.drawing())) {
                return this.isRunning;
            }
            I_XmlBlasterAccess con = this.global.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.global, name, "secret");
            con.connect(qos, this);
            this.isRunning = true;
            if (this.cmdInstances.size() > 0) {
                MonitorCommand[] oidCommands = this.cmdInstances.values().toArray(new MonitorCommand[this.cmdInstances.size()]);
                i = 0;
                while (i < oidCommands.length) {
                    con.subscribe("<key oid='" + oidCommands[i].getOid() + "'/>", "<qos/>");
                    ++i;
                }
            }
            if (this.cmdTemplates.size() > 0) {
                MonitorCommand[] xpathCommands = this.cmdTemplates.values().toArray(new MonitorCommand[this.cmdTemplates.size()]);
                i = 0;
                while (i < xpathCommands.length) {
                    con.subscribe("<key oid='' queryType='XPATH'>//" + xpathCommands[i].getType() + "</key>", "<qos/>");
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return this.isRunning;
    }

    public void stop() {
        I_XmlBlasterAccess con = this.global.getXmlBlasterAccess();
        con.disconnect(null);
    }

    private MonitorCommand searchInTemplates(String oid) {
        String[] keys = this.cmdTemplates.keySet().toArray(new String[this.cmdTemplates.size()]);
        int i = 0;
        while (i < keys.length) {
            if (oid.startsWith(keys[i])) {
                return ((MonitorCommand)this.cmdTemplates.get(keys[i])).createInstance(oid);
            }
            ++i;
        }
        return null;
    }

    public synchronized String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        System.out.println("\nHelloWorld: Received asynchronous message '" + updateKey.getOid() + "' state=" + updateQos.getState() + " from xmlBlaster");
        String oid = updateKey.getOid();
        if (updateQos.isOk()) {
            MonitorCommand command = (MonitorCommand)this.cmdInstances.get(oid);
            if (command == null) {
                command = (MonitorCommand)this.dynamicInstances.get(oid);
            }
            if (command == null && (command = this.searchInTemplates(oid)) != null) {
                this.dynamicInstances.put(oid, command);
                this.view.drawing().add(command.getFigure());
            }
            if (command != null) {
                command.doAction(content, this.view);
            }
        } else {
            MonitorCommand command = (MonitorCommand)this.dynamicInstances.remove(oid);
            if (command != null) {
                command.remove(this.view);
            }
        }
        return "";
    }
}

