/*
 * Decompiled with CFR 0.152.
 */
package javaclients.graphical;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.samples.javadraw.JavaDrawApp;
import java.io.File;
import java.util.HashMap;
import javaclients.graphical.MonitorSubscriber;
import javax.swing.JFileChooser;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;

public class MonitoringAppl
extends JavaDrawApp {
    private Global global;
    private LogChannel log;
    private String ME = "MonitoringAppl";
    private HashMap subscribers;
    private int count;
    private JFileChooser chooser;

    public MonitoringAppl(Global global) {
        super("MonitoringAppl");
        this.global = global;
        this.log = this.global.getLog("monitor");
        this.subscribers = new HashMap();
        this.count = 1;
    }

    public void fireViewDestroyingEvent(DrawingView view) {
        MonitorSubscriber subscriber;
        if (this.log.CALL) {
            this.log.call(this.ME, "fireViewDestroyingEvent(view)");
        }
        if ((subscriber = (MonitorSubscriber)this.subscribers.remove(view)) != null) {
            subscriber.stop();
        }
        super.fireViewDestroyingEvent(view);
    }

    public JFileChooser createOpenFileChooser() {
        if (this.log.CALL) {
            this.log.call(this.ME, "createOpenFileChooser");
        }
        if (this.chooser == null) {
            this.chooser = super.createOpenFileChooser();
            this.chooser.setCurrentDirectory(new File("."));
        }
        return this.chooser;
    }

    public void fireViewCreatedEvent(DrawingView view) {
        super.fireViewCreatedEvent(view);
        MonitorSubscriber subscriber = new MonitorSubscriber(this.global, view);
        String name = "drawing" + this.count++;
        if (subscriber.start(name)) {
            this.subscribers.put(view, subscriber);
        }
    }

    public void exit() {
        if (this.log.CALL) {
            this.log.call(this.ME, "exit");
        }
        if (this.subscribers.size() > 0) {
            try {
                MonitorSubscriber[] subs = this.subscribers.values().toArray(new MonitorSubscriber[this.subscribers.size()]);
                int i = 0;
                while (i < subs.length) {
                    subs[i].stop();
                    ++i;
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        this.subscribers.clear();
        super.exit();
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            System.err.println("Example: java javaclients.graphical.MonitoringAppl -chatMaster true\n");
            System.exit(1);
        }
        MonitoringAppl window = new MonitoringAppl(glob);
        window.open();
    }
}

