/*
 * Decompiled with CFR 0.152.
 */
package javaclients.graphical;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;

public class StorableFigureHolder
implements Storable {
    private static final String ME = "MessageContent";
    private Figure fig;
    private String figId;
    private String toFront;
    private LogChannel log;

    public StorableFigureHolder(LogChannel log, Figure fig, String figId, String toFront) {
        this.log = log;
        this.fig = fig;
        this.figId = figId;
        this.toFront = toFront;
    }

    public StorableFigureHolder() {
        this(null, null, null, null);
        this.log = Global.instance().getLog("graphical");
    }

    public void write(StorableOutput out) {
        if (this.figId != null) {
            out.writeString(this.figId);
        } else {
            out.writeString("");
        }
        if (this.toFront != null) {
            out.writeString(this.toFront);
        } else {
            out.writeString("");
        }
        out.writeStorable((Storable)this.fig);
    }

    public void read(StorableInput in) throws IOException {
        this.figId = in.readString();
        this.toFront = in.readString();
        this.fig = (Figure)in.readStorable();
        if (this.figId.length() < 1) {
            this.figId = null;
        }
        if (this.toFront.length() < 1) {
            this.toFront = null;
        }
    }

    public String getFigureId() {
        return this.figId;
    }

    public String getToFront() {
        return this.toFront;
    }

    public void setFigureId(String figId) {
        this.figId = figId;
    }

    public void setToFront(String toFront) {
        this.toFront = toFront;
    }

    public Figure getFigure() {
        if (this.log.TRACE) {
            this.log.trace(ME, "getFigure: figureId='" + this.figId + "' toFront='" + this.toFront + "' toFront='" + this.fig.displayBox().x + "' toFront='" + this.fig.displayBox().y + "' toFront='" + this.fig.displayBox().width + "' toFront='" + this.fig.displayBox().height + "'");
        }
        return this.fig;
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        StorableOutput out = new StorableOutput((OutputStream)byteStream);
        out.writeStorable((Storable)this);
        out.close();
        return byteStream.toByteArray();
    }

    public static StorableFigureHolder fromBytes(byte[] bytes) throws IOException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        StorableInput in = new StorableInput((InputStream)byteStream);
        return (StorableFigureHolder)in.readStorable();
    }
}

