/*
 * Decompiled with CFR 0.152.
 */
package javaclients.graphical;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.standard.StandardDrawing;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javaclients.graphical.StorableFigureHolder;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.Timeout;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.HistoryQos;

public class XmlBlasterDrawing
extends StandardDrawing
implements I_Timeout,
I_Callback {
    private static final String ME = "XmlBlasterDrawing";
    private Global global;
    private LogChannel log;
    private boolean doPublishEvent;
    private HashMap timestampFigureTable;
    private HashMap figureTimestampTable;
    private HashSet[] newChanged;
    private int currentIndex = 0;
    private int publishIndex = 1;
    private Timeout timeout;
    private long publishDelay = 5000L;
    private I_XmlBlasterAccess access;
    private SubscribeReturnQos subRetQos;
    private String drawingName = "GraphicChat";
    private SubscribeReturnQos subscribeReturnQos;
    private boolean isBurstPublish;

    public XmlBlasterDrawing() {
        this.init(Global.instance());
        if (this.log.CALL) {
            this.log.call(ME, "default contructor");
        }
    }

    public XmlBlasterDrawing(Global global) {
        this.init(global);
        if (this.log.CALL) {
            this.log.call(ME, "global contructor");
        }
    }

    public void init(Global global) {
        this.global = global.getClone(null);
        this.log = this.global.getLog("graphical");
        if (this.log.CALL) {
            this.log.call(ME, "init");
        }
        this.doPublishEvent = true;
        this.timestampFigureTable = new HashMap();
        this.figureTimestampTable = new HashMap();
        this.newChanged = new HashSet[2];
        int i = 0;
        while (i < 2) {
            this.newChanged[i] = new HashSet();
            ++i;
        }
        this.publishDelay = this.global.getProperty().get("publishDelay", 200L);
        this.isBurstPublish = this.publishDelay > 0L;
        if (this.isBurstPublish) {
            this.timeout = new Timeout("PublishTimer");
            this.timeout.addTimeoutListener(this, this.publishDelay, this);
        }
        if (this.getTitle() != null) {
            this.drawingName = this.getTitle();
        }
        this.initConnection();
    }

    public void initConnection() {
        try {
            if (this.log.CALL) {
                this.log.call(ME, "initConnection");
            }
            this.access = this.global.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.global);
            this.access.connect(qos, this);
            SubscribeKey sk = new SubscribeKey(this.global, "/xmlBlaster/key[drawingName='" + this.drawingName + "']", "XPATH");
            SubscribeQos sq = new SubscribeQos(this.global);
            sq.setWantLocal(false);
            sq.setWantInitialUpdate(true);
            HistoryQos historyQos = new HistoryQos(this.global);
            historyQos.setNumEntries(1);
            sq.setHistoryQos(historyQos);
            this.subscribeReturnQos = this.access.subscribe(sk, sq);
        }
        catch (XmlBlasterException ex) {
            this.log.error(ME, "initConnection. Exception : " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public synchronized void shutdown() {
        if (this.log.CALL) {
            this.log.call(ME, "shutdown");
        }
        try {
            if (this.subscribeReturnQos != null) {
                this.access.unSubscribe(new UnSubscribeKey(this.global, this.subscribeReturnQos.getSubscriptionId()), new UnSubscribeQos(this.global));
            }
            this.access.disconnect(new DisconnectQos(this.global));
            this.log.info(ME, "successfully shutdown drawing (unsubscribed and disconnected");
        }
        catch (XmlBlasterException ex) {
            this.log.error(ME, "shutdown. Exception : " + ex.getMessage());
        }
    }

    private synchronized void swapIndex() {
        if (this.currentIndex == 0) {
            this.currentIndex = 1;
            this.publishIndex = 0;
        } else {
            this.currentIndex = 0;
            this.publishIndex = 1;
        }
    }

    public synchronized void figureChanged(FigureChangeEvent e) {
        if (this.log.CALL) {
            this.log.call(ME, "figureChanged event='" + e.toString() + "'");
        }
        if (e.getFigure() instanceof Drawing) {
            if (this.log.TRACE) {
                this.log.trace(ME, "figureChanged for a Drawing instance " + e.getFigure());
            }
            return;
        }
        super.figureChanged(e);
        if (this.doPublishEvent) {
            StorableFigureHolder figureHolder = this.getFigureHolder(e.getFigure());
            if (this.isBurstPublish) {
                this.newChanged[this.currentIndex].add(figureHolder);
            } else {
                this.publish(figureHolder);
            }
        }
        if (this.log.CALL) {
            this.log.call(ME, "figureChanged " + e.getFigure());
        }
    }

    protected void addToTable(StorableFigureHolder figureHolder) {
        String figureId = figureHolder.getFigureId();
        Figure figure = figureHolder.getFigure();
        HashMap hashMap = this.timestampFigureTable;
        synchronized (hashMap) {
            this.figureTimestampTable.put(figure, figureHolder);
            this.timestampFigureTable.put(figureId, figureHolder);
        }
    }

    protected void removeFromTable(StorableFigureHolder figureHolder) {
        if (this.log.CALL) {
            this.log.call(ME, "remove");
        }
        String figureId = figureHolder.getFigureId();
        Figure figure = figureHolder.getFigure();
        HashMap hashMap = this.timestampFigureTable;
        synchronized (hashMap) {
            if (figure != null) {
                this.figureTimestampTable.remove(figure);
            }
            if (figureId != null) {
                this.timestampFigureTable.remove(figureId);
            }
        }
    }

    private StorableFigureHolder getFigureHolder(Figure figure) {
        StorableFigureHolder figureHolder = (StorableFigureHolder)this.figureTimestampTable.get(figure);
        if (figureHolder == null) {
            String timestamp = "" + new Timestamp().getTimestampLong();
            String figureId = this.drawingName + "-" + timestamp;
            figureHolder = new StorableFigureHolder(this.log, figure, figureId, null);
            this.addToTable(figureHolder);
        }
        return figureHolder;
    }

    public synchronized Figure add(Figure figure) {
        if (this.log.CALL) {
            this.log.call(ME, "add");
        }
        if (figure instanceof Drawing) {
            return figure;
        }
        if (this.doPublishEvent) {
            StorableFigureHolder figureHolder = this.getFigureHolder(figure);
            if (this.isBurstPublish) {
                this.newChanged[this.currentIndex].add(figureHolder);
            } else {
                this.publish(figureHolder);
            }
            if (this.log.TRACE) {
                this.log.trace(ME, "add: adding '" + figureHolder.getFigureId() + "'");
            }
        }
        return super.add(figure);
    }

    public synchronized void bringToFront(Figure figure) {
        if (this.log.CALL) {
            this.log.call(ME, "bringToFront");
        }
        if (this.doPublishEvent) {
            ((StorableFigureHolder)this.figureTimestampTable.get(figure)).setToFront("true");
        }
        super.bringToFront(figure);
    }

    public synchronized Figure orphan(Figure figure) {
        if (this.log.CALL) {
            this.log.call(ME, "orphan");
        }
        if (figure instanceof Drawing) {
            return figure;
        }
        if (this.doPublishEvent) {
            try {
                this.erase(figure);
            }
            catch (XmlBlasterException ex) {
                String figureId = ((StorableFigureHolder)this.figureTimestampTable.get(figure)).getFigureId();
                this.log.error(ME, "orphan '" + figureId + "' exception : " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return super.orphan(figure);
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.log.CALL) {
            this.log.call(ME, "sendToBack");
        }
        if (this.doPublishEvent) {
            ((StorableFigureHolder)this.figureTimestampTable.get(figure)).setToFront("false");
        }
        super.sendToBack(figure);
    }

    public synchronized void sendToLayer(Figure figure, int layerNr) {
        if (this.log.CALL) {
            this.log.call(ME, "sendToLayer");
        }
        super.sendToLayer(figure, layerNr);
    }

    public synchronized void setTitle(String name) {
        if (this.log.CALL) {
            this.log.call(ME, "");
        }
        super.setTitle(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void timeout(Object userData) {
        try {
            try {
                this.swapIndex();
                if (this.newChanged[this.publishIndex].size() == 0) {
                    Object var5_2 = null;
                    this.timeout.addTimeoutListener(this, this.publishDelay, this);
                    return;
                }
                Iterator iter = this.newChanged[this.publishIndex].iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        this.newChanged[this.publishIndex].clear();
                        break;
                    }
                    StorableFigureHolder figureHolder = (StorableFigureHolder)iter.next();
                    if (figureHolder.getFigure() instanceof Drawing) continue;
                    this.publish(figureHolder);
                }
            }
            catch (Throwable ex) {
                this.log.warn(ME, "timeout: exception occured in timeout: " + ex.getMessage());
                ex.printStackTrace();
                Object var5_4 = null;
                this.timeout.addTimeoutListener(this, this.publishDelay, this);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.timeout.addTimeoutListener(this, this.publishDelay, this);
            throw throwable;
        }
        Object var5_3 = null;
        this.timeout.addTimeoutListener(this, this.publishDelay, this);
    }

    private void publish(StorableFigureHolder figureHolder) {
        if (this.log.CALL) {
            this.log.call(ME, "publish");
        }
        if (figureHolder == null || figureHolder.getFigure() instanceof Drawing) {
            return;
        }
        try {
            String figureId = figureHolder.getFigureId();
            if (this.log.TRACE) {
                this.log.trace(ME, "publish '" + figureId + "'");
            }
            PublishKey pk = new PublishKey(this.global, figureId, "application/draw", "1.0");
            pk.setClientTags("<drawingName>" + this.drawingName + "</drawingName>");
            PublishQos pq = new PublishQos(this.global);
            MsgUnit msgUnit = new MsgUnit(pk, figureHolder.toBytes(), pq);
            this.access.publish(msgUnit);
        }
        catch (IOException ex) {
            this.log.error(ME, "exception occured when publishing: " + ex.toString());
        }
        catch (XmlBlasterException ex) {
            this.log.error(ME, "exception occured when publishing: " + ex.getMessage());
        }
    }

    private void publishMetaInfo(String data) {
        if (this.log.CALL) {
            this.log.call(ME, "publishMetaInfo");
        }
        try {
            PublishKey pk = new PublishKey(this.global, null, "text/plain", "1.0");
            pk.setClientTags("<drawingMetadata>" + this.drawingName + "</drawingMetadata>");
            PublishQos pq = new PublishQos(this.global);
            MsgUnit msgUnit = new MsgUnit(pk, data.getBytes(), pq);
            this.access.publish(msgUnit);
        }
        catch (XmlBlasterException ex) {
            this.log.error(ME, "exception occured when publishing: " + ex.getMessage());
        }
    }

    private void erase(Figure figure) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "erase");
        }
        if (figure == null) {
            return;
        }
        StorableFigureHolder figureHolder = (StorableFigureHolder)this.figureTimestampTable.get(figure);
        if (figureHolder == null) {
            return;
        }
        String figureId = figureHolder.getFigureId();
        if (this.log.TRACE) {
            this.log.trace(ME, "erase '" + figureId + "'");
        }
        EraseKey ek = new EraseKey(this.global, figureId);
        EraseQos eq = new EraseQos(this.global);
        EraseReturnQos[] eraseArr = this.access.erase(ek, eq);
        this.removeFromTable(figureHolder);
    }

    private void currentFigureUpdate(StorableFigureHolder figureHolder) {
        if (this.log.CALL) {
            this.log.call(ME, "currentFigureUpdate");
        }
        boolean sendToBack = false;
        boolean sendToFront = false;
        String toFront = figureHolder.getToFront();
        if (toFront != null) {
            boolean val = "true".equalsIgnoreCase(toFront);
            this.log.info(ME, "update: the attribute 'TO_FRONT' is set to '" + val + "'");
            if (val) {
                sendToFront = true;
            } else {
                sendToBack = true;
            }
        }
        String figureId = figureHolder.getFigureId();
        if (this.log.TRACE) {
            this.log.trace(ME, "currentFigureUpdate figureId='" + figureId + "'");
        }
        if (figureId == null) {
            return;
        }
        this.log.info(ME, "update figure: '" + figureId + "' changed or added");
        StorableFigureHolder oldFigureHolder = (StorableFigureHolder)this.timestampFigureTable.get(figureId);
        Figure fig = figureHolder.getFigure();
        if (oldFigureHolder == null) {
            this.addToTable(figureHolder);
            super.add(fig);
        } else {
            Figure oldFigure = oldFigureHolder.getFigure();
            super.replace(oldFigure, fig);
            this.removeFromTable(oldFigureHolder);
            this.addToTable(figureHolder);
            FigureChangeEvent ev = new FigureChangeEvent(oldFigure);
            this.figureRequestUpdate(ev);
            if (sendToFront) {
                if (this.log.TRACE) {
                    this.log.trace(ME, "update: send to front");
                }
                this.bringToFront(fig);
            } else if (sendToBack) {
                if (this.log.TRACE) {
                    this.log.trace(ME, "update: send to back");
                }
                this.sendToBack(fig);
            }
        }
        FigureChangeEvent ev1 = new FigureChangeEvent(fig);
        this.figureRequestUpdate(ev1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        block9: {
            String string;
            block8: {
                this.log.info(ME, "update for '" + cbSessionId + "', '" + updateKey.getOid() + "' length of msg is '" + content.length + "'");
                try {
                    try {
                        this.lock();
                        this.doPublishEvent = false;
                        if (updateQos.isErased()) {
                            this.log.info(ME, "Message '" + updateKey.getOid() + "' is erased");
                            String figureId = updateKey.getOid();
                            StorableFigureHolder figHolder = (StorableFigureHolder)this.timestampFigureTable.get(figureId);
                            if (figHolder != null) {
                                this.removeFromTable(figHolder);
                                Figure fig = figHolder.getFigure();
                                Figure figToRelease = super.orphan(fig);
                                FigureChangeEvent ev = new FigureChangeEvent(fig);
                                this.figureRequestUpdate(ev);
                                figToRelease.release();
                            }
                            string = "OK";
                            Object var11_13 = null;
                            this.doPublishEvent = true;
                            break block8;
                        }
                        StorableFigureHolder figureHolder = StorableFigureHolder.fromBytes(content);
                        this.currentFigureUpdate(figureHolder);
                        break block9;
                    }
                    catch (IOException ex) {
                        this.log.error(ME, "update: an IOException occured when reconstructing the content: " + ex.getMessage());
                        Object var11_15 = null;
                        this.doPublishEvent = true;
                        this.unlock();
                        return "OK";
                    }
                    catch (Throwable ex) {
                        this.log.error(ME, "update: a Throwable occured when reconstructing the content (acknowledge anyway): " + ex.getMessage());
                        ex.printStackTrace();
                        Object var11_16 = null;
                        this.doPublishEvent = true;
                        this.unlock();
                        return "OK";
                    }
                }
                catch (Throwable throwable) {
                    Object var11_17 = null;
                    this.doPublishEvent = true;
                    this.unlock();
                    throw throwable;
                }
            }
            this.unlock();
            return string;
        }
        Object var11_14 = null;
        this.doPublishEvent = true;
        this.unlock();
        return "OK";
    }

    public void release() {
        if (this.log.CALL) {
            this.log.call(ME, "release");
        }
        this.shutdown();
        super.release();
    }
}

