/*
 * Decompiled with CFR 0.152.
 */
package javaclients.jdbc;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.XmlDbMessageWrapper;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;

public class XmlDBClient
implements I_Callback {
    private static String ME = "XmlDBClient";
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess con = null;
    private String results;
    private boolean done = false;

    public XmlDBClient(Global glob) {
        this.glob = glob;
        this.log = this.glob.getLog("client");
        this.initBlaster();
        this.query();
        this.waitOnResults();
    }

    private void waitOnResults() {
        while (!this.done) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.log.plain(ME, "Waiting...");
        }
        this.log.plain(ME, this.results);
        this.logout();
    }

    public String update(String cbSessionId, UpdateKey key, byte[] content, UpdateQos updateQos) {
        this.results = new String(content);
        this.log.info(ME, "Receiving message oid=" + key.getOid() + " state=" + updateQos.getState());
        this.done = true;
        return "";
    }

    public void initBlaster() {
        try {
            this.con = this.glob.getXmlBlasterAccess();
            this.con.connect(null, this);
            this.log.info(ME, "Connected to xmlBlaster");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(ME, "Login to xmlBlaster failed");
            System.exit(1);
        }
    }

    public void logout() {
        if (this.con == null) {
            return;
        }
        this.log.info(ME, "Logout ...");
        this.con.disconnect(null);
    }

    private void query() {
        XmlDbMessageWrapper wrap = new XmlDbMessageWrapper(this.glob, this.glob.getProperty().get("user", "postgres"), this.glob.getProperty().get("pass", ""), this.glob.getProperty().get("url", "jdbc:postgresql://24.3.47.214/postgres"));
        boolean confirm = this.glob.getProperty().get("confirm", true);
        String type = this.glob.getProperty().get("type", "query");
        int limit = this.glob.getProperty().get("limit", 50);
        String queryStr = this.glob.getProperty().get("query", "select * from intrauser");
        wrap.init(type, limit, confirm, queryStr);
        try {
            this.con.publish(wrap.toMessage());
            this.log.info(ME, "Published query ...");
            if (this.log.DUMP) {
                this.log.dump(ME, wrap.toXml());
            }
        }
        catch (Exception e) {
            this.log.error(ME, e.getMessage());
        }
        if (!queryStr.equalsIgnoreCase("query") && !confirm) {
            this.logout();
            this.log.info(ME, "Done, no waiting on confirmation");
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        XmlDBClient xmlDBClient = new XmlDBClient(new Global(args));
    }
}

