/*
 * Decompiled with CFR 0.152.
 */
package javaclients.jdbc;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.XmlDbMessageWrapper;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;

public class XmlDBClientSync {
    private static String ME = "XmlDBClientSync";
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess corbaConnection = null;

    public XmlDBClientSync(Global glob) {
        this.glob = glob;
        this.log = glob.getLog(null);
        this.initBlaster();
        this.query();
        this.logout();
    }

    public void initBlaster() {
        try {
            this.corbaConnection = this.glob.getXmlBlasterAccess();
            this.corbaConnection.connect(null, null);
            this.log.info(ME, "Connected to xmlBlaster");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(ME, "Login to xmlBlaster failed");
            System.exit(1);
        }
    }

    public void logout() {
        if (this.corbaConnection == null) {
            return;
        }
        this.log.info(ME, "Logout ...");
        this.corbaConnection.disconnect(null);
    }

    private void query() {
        XmlDbMessageWrapper wrap = new XmlDbMessageWrapper(this.glob, this.glob.getProperty().get("user", "postgres"), this.glob.getProperty().get("pass", ""), this.glob.getProperty().get("url", "jdbc:postgresql://24.3.47.214/postgres"));
        boolean confirm = this.glob.getProperty().get("confirm", true);
        String type = this.glob.getProperty().get("type", "query");
        int limit = this.glob.getProperty().get("limit", 50);
        String queryStr = this.glob.getProperty().get("query", "select * from intrauser");
        wrap.init(type, limit, confirm, queryStr);
        try {
            this.log.info(ME, "Sending command string:\n" + wrap.toXml());
            GetKey key = new GetKey(this.glob, "__sys__jdbc");
            key.wrap(wrap.toXml());
            GetQos qos = new GetQos(this.glob);
            MsgUnit[] msgUnitArr = this.corbaConnection.get(key.toXml(), qos.toXml());
            if (msgUnitArr.length > 0) {
                this.log.plain(ME, new String(msgUnitArr[0].getContent()));
            } else {
                this.log.info(ME, "No results for your query");
            }
        }
        catch (Exception e) {
            this.log.error(ME, "Query failed: " + e.toString());
        }
    }

    public static void main(String[] args) {
        new XmlDBClientSync(new Global(args));
    }
}

