/*
 * Decompiled with CFR 0.152.
 */
package javaclients.rmi;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.protocol.rmi.I_AuthServer;
import org.xmlBlaster.protocol.rmi.I_XmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class ClientGet {
    private static String ME = "Heidi";
    private final Global glob;
    private final LogChannel log;
    private I_AuthServer authServer = null;
    private I_XmlBlaster blasterServer = null;
    private String sessionId = null;

    public ClientGet(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("client");
        try {
            PublishReturnQos q;
            String pubXml;
            this.initRmi();
            String loginName = glob.getProperty().get("loginName", "RMIClient");
            String passwd = glob.getProperty().get("passwd", "secret");
            ConnectQos qos = new ConnectQos(glob, loginName, passwd);
            this.log.info(ME, "Trying login to '" + loginName + "'");
            String retXml = this.authServer.connect(qos.toXml());
            ConnectReturnQos conRetQos = new ConnectReturnQos(glob, retXml);
            this.sessionId = conRetQos.getSecretSessionId();
            String publishOid = "";
            StopWatch stop = new StopWatch();
            String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='' contentMime='text/xml'>   <AGENT id='192.168.124.10' subId='1' type='generic'>      <DRIVER id='FileProof' pollingFreq='10'>      </DRIVER>   </AGENT></key>";
            String content = "<file><size>1024 kBytes</size><creation>1.1.2000</creation></file>";
            MsgUnitRaw msgUnit = new MsgUnitRaw(xmlKey, content.getBytes(), "<qos></qos>");
            this.log.trace(ME, "Publishing ...");
            stop.restart();
            try {
                pubXml = this.blasterServer.publish(this.sessionId, msgUnit);
                q = new PublishReturnQos(glob, pubXml);
                publishOid = q.getKeyOid();
                this.log.info(ME, "   Returned oid=" + publishOid);
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            this.log.trace(ME, "Publishing done" + stop.nice());
            this.log.trace(ME, "get() using the exact oid ...");
            xmlKey = "<key oid='" + publishOid + "' queryType='EXACT'>\n" + "</key>";
            stop.restart();
            MsgUnitRaw[] msgArr = null;
            try {
                msgArr = this.blasterServer.get(this.sessionId, xmlKey, "<qos></qos>");
                this.log.info(ME, "Got " + msgArr.length + " messages:");
                int ii = 0;
                while (ii < msgArr.length) {
                    this.log.plain(ME, msgArr[ii].getKey() + "\n################### RETURN CONTENT: ##################\n\n" + new String(msgArr[ii].getContent()) + "\n\n#######################################");
                    ++ii;
                }
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "XmlBlasterException: " + e.getMessage());
                System.exit(1);
            }
            xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='Export-11' contentMime='text/plain'><AGENT id='192.168.124.29' subId='1' type='generic'><DRIVER id='ProgramExecute'><EXECUTABLE>export</EXECUTABLE><FILE>out.txt</FILE></DRIVER></AGENT></key>";
            content = "Export program started";
            msgUnit = new MsgUnitRaw(xmlKey, content.getBytes(), "<qos></qos>");
            this.log.trace(ME, "Publishing ...");
            stop.restart();
            try {
                pubXml = this.blasterServer.publish(this.sessionId, msgUnit);
                q = new PublishReturnQos(glob, pubXml);
                publishOid = q.getKeyOid();
                this.log.info(ME, "   Returned oid=" + publishOid);
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            }
            this.log.trace(ME, "Publishing done" + stop.nice());
            this.log.trace(ME, "get() using the Xpath query syntax ...");
            xmlKey = "<key oid='' queryType='XPATH'>\n   //DRIVER[@id='ProgramExecute']</key>";
            stop.restart();
            msgArr = null;
            try {
                msgArr = this.blasterServer.get(this.sessionId, xmlKey, "<qos></qos>");
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "XmlBlasterException: " + e.getMessage());
            }
            if (msgArr.length == 1) {
                this.log.info(ME, "Got " + msgArr.length + " messages:");
            } else {
                this.log.error(ME, "Got " + msgArr.length + " messages:");
            }
            int ii = 0;
            while (ii < msgArr.length) {
                this.log.plain(ME, msgArr[ii].getKey() + "\n################### RETURN CONTENT: ##################\n\n" + new String(msgArr[ii].getContent()) + "\n\n#######################################");
                ++ii;
            }
            this.authServer.disconnect(this.sessionId, "<qos/>");
        }
        catch (RemoteException e) {
            this.log.error(ME, "Error occurred: " + e.toString());
            e.printStackTrace();
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlaster error occurred: " + e.toString());
            e.printStackTrace();
        }
    }

    private void initRmi() throws XmlBlasterException {
        String hostname;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
            if (this.log.TRACE) {
                this.log.trace(ME, "Started RMISecurityManager");
            }
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
        }
        catch (Exception e) {
            this.log.warn(ME, "Can't determin your hostname");
            hostname = "localhost";
        }
        hostname = this.glob.getProperty().get("dispatch/clientside/plugin/rmi/hostname", hostname);
        int registryPort = this.glob.getProperty().get("dispatch/connection/plugin/rmi/registryPort", 1099);
        String prefix = "rmi://" + hostname + ":" + registryPort + "/";
        String authServerUrl = prefix + "I_AuthServer";
        String addr = this.glob.getProperty().get("AuthServerUrl", authServerUrl);
        Remote rem = this.lookup(addr);
        if (!(rem instanceof I_AuthServer)) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_CLIENTCODE, "InvalidRmiCallback", "No to '" + addr + "' possible, class needs to implement interface I_AuthServer.");
        }
        this.authServer = (I_AuthServer)rem;
        this.log.info(ME, "Accessing reference using given '" + addr + "' string");
        String xmlBlasterUrl = prefix + "I_XmlBlaster";
        addr = this.glob.getProperty().get("XmlBlasterUrl", xmlBlasterUrl);
        rem = this.lookup(addr);
        if (!(rem instanceof I_XmlBlaster)) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_CLIENTCODE, "InvalidRmiCallback", "No to '" + addr + "' possible, class needs to implement interface I_XmlBlaster.");
        }
        this.blasterServer = (I_XmlBlaster)rem;
        this.log.info(ME, "Accessing reference using given '" + addr + "' string");
    }

    private Remote lookup(String addr) throws XmlBlasterException {
        try {
            return Naming.lookup(addr);
        }
        catch (RemoteException e) {
            this.log.error(ME, "Can't access address ='" + addr + "', no rmi registry running");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_CLIENTCODE, "CallbackHandleInvalid", "Can't access address ='" + addr + "', no rmi registry running");
        }
        catch (NotBoundException e) {
            this.log.error(ME, "The given address ='" + addr + "' is not bound to rmi registry: " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.USER_CLIENTCODE, "CallbackHandleInvalid", "The given address '" + addr + "' is not bound to rmi registry: " + e.toString());
        }
        catch (MalformedURLException e) {
            this.log.error(ME, "The given address ='" + addr + "' is invalid: " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.USER_CLIENTCODE, "CallbackHandleInvalid", "The given address '" + addr + "' is invalid: " + e.toString());
        }
        catch (Throwable e) {
            this.log.error(ME, "The given address ='" + addr + "' is invalid : " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.USER_CLIENTCODE, "CallbackHandleInvalid", "The given address '" + addr + "' is invalid : " + e.toString());
        }
    }

    public static void main(String[] args) {
        new ClientGet(new Global(args));
    }
}

