/*
 * Decompiled with CFR 0.152.
 */
package javaclients.script;

import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.script.XmlScriptInterpreter;
import org.xmlBlaster.util.Global;

public class XmlScript {
    private static String ME = "XmlScript";
    private final Global glob;
    private final LogChannel log;
    private XmlScriptInterpreter interpreter;
    private Reader reader;
    private OutputStream outStream;
    private OutputStream updStream;

    public XmlScript(Global glob, String inFile, String outFile, String updFile) {
        this.glob = glob;
        this.log = glob.getLog("demo");
        try {
            this.reader = inFile == null ? new InputStreamReader(System.in) : new FileReader(inFile);
            this.outStream = outFile == null ? System.out : new FileOutputStream(outFile);
            this.updStream = updFile == null ? this.outStream : new FileOutputStream(updFile);
            this.interpreter = new XmlScriptInterpreter(this.glob, this.glob.getXmlBlasterAccess(), this.outStream, this.updStream, null);
            this.interpreter.parse(this.reader);
        }
        catch (Exception e) {
            this.log.error(ME, "Client failed: " + e.toString());
        }
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(glob.usage());
            System.out.println("Get help: java javaclients.script.XmlScript -help\n");
            System.out.println("Example: java javaclients.XmlScript -requestFile inFile.xml -responseFile outFile.xml -updateFile updFile.xml\n");
            System.out.println("  if you don't specify anything as '-requestFile', then the standard input stream is taken.\n");
            System.out.println("  if you don't specify anything as '-responseFile', then the standard output stream is taken.\n");
            System.out.println("  if you don't specify anything as '-updateFile', then the same stream as for the output stream is used.\n");
            System.exit(1);
        }
        String inFile = glob.getProperty().get("requestFile", (String)null);
        String outFile = glob.getProperty().get("responseFile", (String)null);
        String updFile = glob.getProperty().get("updateFile", (String)null);
        new XmlScript(glob, inFile, outFile, updFile);
    }
}

