/*
 * Decompiled with CFR 0.152.
 */
package javaclients.svg.batik;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javaclients.svg.batik.Interactor;
import javaclients.svg.batik.JSVGCanvasExtended;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;

public class ExtendedApplication {
    private static final String ME = "ExtendedApplication";
    private final Global glob;
    private final LogChannel log;
    JFrame frame;
    JButton button = new JButton("Load...");
    JLabel label = new JLabel();
    JSVGCanvasExtended svgCanvasExtended = null;

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println("ExtendedApplication Init failed");
            System.exit(1);
        }
        JFrame f = new JFrame("Batik");
        ExtendedApplication app = new ExtendedApplication(glob, f);
        f.getContentPane().add(app.createComponents());
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ((Component)f).setSize(400, 400);
        ((Component)f).setVisible(true);
    }

    public ExtendedApplication(Global glob, JFrame f) {
        this.glob = glob;
        this.log = glob.getLog(null);
        this.frame = f;
        this.svgCanvasExtended = new JSVGCanvasExtended(glob);
    }

    public JComponent createComponents() {
        final JPanel panel = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new FlowLayout(0));
        p.add(this.button);
        p.add(this.label);
        panel.add("North", p);
        panel.add("Center", (Component)((Object)this.svgCanvasExtended));
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFileChooser fc = new JFileChooser(".");
                int choice = fc.showOpenDialog(panel);
                if (choice == 0) {
                    File f = fc.getSelectedFile();
                    try {
                        ExtendedApplication.this.svgCanvasExtended.setURI(f.toURL().toString());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.svgCanvasExtended.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)new SimpleLoaderAdapter(this.glob, this.svgCanvasExtended.getSpecificInteractor()));
        this.svgCanvasExtended.addGVTTreeBuilderListener((GVTTreeBuilderListener)new GVTTreeBuilderAdapter(){

            public void gvtBuildStarted(GVTTreeBuilderEvent e) {
                ExtendedApplication.this.label.setText("Build Started...");
                ExtendedApplication.this.log.trace(ExtendedApplication.ME, "Build Started...");
            }

            public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                ExtendedApplication.this.label.setText("Build Done.");
                ExtendedApplication.this.log.info(ExtendedApplication.ME, "Build Done.");
                ExtendedApplication.this.frame.pack();
            }
        });
        this.svgCanvasExtended.addGVTTreeRendererListener((GVTTreeRendererListener)new SimpleGVTTreeRendererAdapter(this.glob, this.svgCanvasExtended));
        return panel;
    }

    protected class SimpleGVTTreeRendererAdapter
    extends GVTTreeRendererAdapter {
        private JSVGCanvasExtended canvas = null;
        private final String ME = "SimpleGVTTreeRendererAdapter";
        private LogChannel log;

        public SimpleGVTTreeRendererAdapter(Global glob, JSVGCanvasExtended canvas) {
            this.log = glob.getLog("batik");
            this.canvas = canvas;
            this.log.trace("SimpleGVTTreeRendererAdapter", " constructor");
        }

        public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
            ExtendedApplication.this.label.setText("Rendering Started...");
            this.log.trace("SimpleGVTTreeRendererAdapter", "Rendering Started...");
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
            ExtendedApplication.this.label.setText("");
            this.canvas.updateDocument();
            this.log.info("SimpleGVTTreeRendererAdapter", "Rendering ended...");
        }
    }

    protected class SimpleLoaderAdapter
    extends SVGDocumentLoaderAdapter {
        private Interactor specialInteractor = null;
        private final String ME = "SimpleLoaderAdapter";
        private LogChannel log;

        public SimpleLoaderAdapter(Global glob, Interactor specialInteractor) {
            this.log = glob.getLog("batik");
            this.specialInteractor = specialInteractor;
            this.log.trace("SimpleLoaderAdapter", " constructor");
        }

        public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
            this.log.trace("SimpleLoaderAdapter", ".documentLoadingStarted");
        }

        public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
            this.log.info("SimpleLoaderAdapter", ".documentLoadingCompleted");
        }
    }
}

