/*
 * Decompiled with CFR 0.152.
 */
package javaclients.svg.batik;

import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javaclients.svg.batik.Transceiver;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class Interactor
extends InteractorAdapter {
    private final String ME = "Interactor";
    private final LogChannel log = Global.instance().getLog("batik");
    private JSVGCanvas canvas = null;
    private GraphicsNode graphicsNode = null;
    private Point lastMousePosition = null;
    private GraphicsNode selectedGraphicsNode = null;
    private BridgeContext bridgeContext = null;
    private Transceiver transceiver = null;

    public Interactor() {
        this.log.trace("Interactor", "constructor called");
    }

    public void setTransceiver(Transceiver transceiver) {
        this.transceiver = transceiver;
    }

    public void setBridgeContext(BridgeContext bridgeContext) {
        this.bridgeContext = bridgeContext;
    }

    public BridgeContext getBridgeContext() {
        return this.bridgeContext;
    }

    public void setCanvas(JSVGCanvas canvas) {
        this.log.trace("Interactor", ".setCanvas start");
        boolean setInteractorList = false;
        System.out.println("Interactor.setCanvas " + canvas + " start");
        if (canvas != this.canvas && canvas != null) {
            this.log.info("Interactor", ".setCanvas interactor list set");
            List interactorList = canvas.getInteractors();
            interactorList.add(this);
        }
        this.canvas = canvas;
        this.log.trace("Interactor", ".setCanvas end");
    }

    public void setGraphicsNode() throws XmlBlasterException {
        this.log.trace("Interactor", ".setGraphicsNode start");
        if (this.canvas == null) {
            this.log.error("Interactor", ".setGraphicsNode canvas is null");
            throw new XmlBlasterException("Interactor", ".setGraphicsNode canvas is null");
        }
        this.graphicsNode = this.canvas.getGraphicsNode();
        if (this.graphicsNode == null) {
            this.log.warn("Interactor", ".setGraphicsNode: the graphics node is null");
        }
        this.log.trace("Interactor", ".setGraphicsNode end");
    }

    public boolean startInteraction(InputEvent ie) {
        this.log.trace("Interactor", ".startInteraction called");
        return true;
    }

    public JSVGCanvas getCanvas() {
        return this.canvas;
    }

    public void mousePressed(MouseEvent evt) {
        this.log.trace("Interactor", ".mousePressed");
        this.lastMousePosition = evt.getPoint();
        Rectangle2D rect = this.graphicsNode.getBounds();
        Point2D.Double point2D = new Point2D.Double();
        ((Point2D)point2D).setLocation(this.lastMousePosition.getX(), this.lastMousePosition.getY());
        this.selectedGraphicsNode = this.graphicsNode.nodeHitAt((Point2D)point2D);
        if (this.selectedGraphicsNode == null) {
            this.log.warn("Interactor", ".mousePressed hit a null object");
        } else {
            this.log.info("Interactor", ".mousePressed hit " + this.selectedGraphicsNode.toString());
        }
    }

    public void mouseDragged(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
        this.log.info("Interactor", ".mouseReleased");
        if (this.lastMousePosition == null) {
            this.log.error("Interactor", "the last mouse position was null");
        } else if (this.selectedGraphicsNode != null) {
            Point p = new Point();
            p.x = evt.getX() - this.lastMousePosition.x;
            p.y = evt.getY() - this.lastMousePosition.y;
            this.transceiver.move(this.selectedGraphicsNode, p);
        } else {
            this.log.warn("Interactor", ".mouseReleased: selectedGraphicsNode was null");
        }
        this.selectedGraphicsNode = null;
        this.lastMousePosition = null;
    }
}

