/*
 * Decompiled with CFR 0.152.
 */
package javaclients.svg.batik;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import javaclients.svg.batik.Interactor;
import javaclients.svg.batik.SvgIdMapper;
import javaclients.svg.batik.SvgUtility;
import javaclients.svg.batik.Transceiver;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.svg.JSVGComponent;
import org.jutils.log.LogChannel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class JSVGCanvasExtended
extends JSVGCanvas {
    private static final String ME = "JSVGCanvasExtended";
    private final LogChannel log;
    private Interactor specificInteractor = null;
    private Transceiver transceiver = null;
    private Hashtable idTable = null;

    public JSVGCanvasExtended(Global glob) {
        this.log = glob.getLog("batik");
        this.specificInteractor = new Interactor();
        this.specificInteractor.setBridgeContext(((JSVGComponent)this).bridgeContext);
        this.specificInteractor.setCanvas(this);
        this.transceiver = new Transceiver(glob, this);
        this.specificInteractor.setTransceiver(this.transceiver);
    }

    public void loadDocumentFromReader(Reader reader) throws IOException {
        this.setSVGDocument((SVGDocument)SvgUtility.createDocument(reader, "file://dummy.svg"));
    }

    public void loadDocumentFromInputStream(InputStream inputStream) throws IOException {
        this.setSVGDocument((SVGDocument)SvgUtility.createDocument(inputStream, "file://dummy.svg"));
    }

    public void loadDocumentFromXmlString(String xmlString) throws IOException {
        this.loadDocumentFromReader(new StringReader(xmlString));
    }

    public void loadDocumentFromByteArray(byte[] byteArray) throws IOException {
        this.loadDocumentFromInputStream(new ByteArrayInputStream(byteArray));
    }

    public Element getElement(String elementId) {
        if (this.idTable == null) {
            return null;
        }
        Object obj = this.idTable.get(elementId);
        if (obj == null) {
            return null;
        }
        return (Element)obj;
    }

    public void updateDocument() {
        try {
            this.specificInteractor.setBridgeContext(((JSVGComponent)this).bridgeContext);
            this.specificInteractor.setGraphicsNode();
            this.transceiver.setBridgeContext(((JSVGComponent)this).bridgeContext);
            SvgIdMapper mapper = new SvgIdMapper();
            this.idTable = mapper.createIdTable((Document)((JSVGComponent)this).svgDocument);
            this.transceiver.subscribeElements();
        }
        catch (XmlBlasterException ex) {
            this.log.error(ME, ".updateDocument: graphicsNode was null");
        }
    }

    public Interactor getSpecificInteractor() {
        return this.specificInteractor;
    }
}

