/*
 * Decompiled with CFR 0.152.
 */
package javaclients.svg.batik;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jutils.log.LogChannel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlBlaster.util.Global;

public class SvgIdMapper {
    private static final String ME = "SvgIdMapper";
    private final LogChannel log = Global.instance().getLog("batik");
    private Hashtable idTable = new Hashtable();

    public static boolean isDynamic(String id) {
        if (id == null) {
            return false;
        }
        return id.startsWith("xmlBlaster.");
    }

    protected void scanNode(Node node) {
        this.log.trace(ME, ".scanNode started");
        if (node instanceof Document) {
            node = ((Document)node).getDocumentElement();
        }
        if (node instanceof Element) {
            NodeList nodeList;
            Element el = (Element)node;
            String idText = el.getAttribute("id");
            if (SvgIdMapper.isDynamic(idText)) {
                this.idTable.put(idText, node);
                this.log.trace(ME, ".scanNode: " + idText);
            }
            if ((nodeList = el.getChildNodes()) != null) {
                int i = 0;
                while (i < nodeList.getLength()) {
                    this.scanNode(nodeList.item(i));
                    ++i;
                }
            }
        }
        this.log.trace(ME, ".scanNode ended");
    }

    public Hashtable createIdTable(Document document) {
        this.log.info(ME, "createIdTable");
        this.idTable = new Hashtable();
        this.scanNode(document);
        return this.idTable;
    }

    public static void main(String[] args) {
        SvgIdMapper mapper = new SvgIdMapper();
        try {
            File file = new File("simple.svg");
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            Hashtable idTable = mapper.createIdTable(doc);
            Enumeration keys = idTable.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                System.out.println(key);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }
}

